/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator.neighbor.kernel;

import java.util.Optional;
import java.util.function.Supplier;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.kernel.NeighborPredicate;
import org.anchoranalysis.image.voxel.kernel.BufferRetriever;
import org.anchoranalysis.image.voxel.kernel.KernelPointCursor;

public class WalkPredicate {
    private final KernelPointCursor point;
    private final NeighborPredicate predicate;
    private final boolean bigNeighborhood;

    public boolean walk(UnsignedByteBuffer buffer, BufferRetriever bufferRetriever) {
        return this.walkX(buffer) || this.walkY(buffer) || this.walkZ(bufferRetriever) || this.maybeQualifyFromBigNeighborhood(buffer);
    }

    private boolean walkX(UnsignedByteBuffer buffer) {
        this.point.decrementX();
        if (this.testIf(this.point.nonNegativeX(), () -> buffer, 0)) {
            this.point.incrementX();
            return true;
        }
        this.point.incrementXTwice();
        try {
            if (this.testIf(this.point.lessThanMaxX(), () -> buffer, 0)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.point.decrementX();
        }
        return false;
    }

    private boolean walkY(UnsignedByteBuffer buffer) {
        this.point.decrementY();
        if (this.testIf(this.point.nonNegativeY(), () -> buffer, 0)) {
            this.point.incrementY();
            return true;
        }
        this.point.incrementYTwice();
        try {
            if (this.testIf(this.point.lessThanMaxY(), () -> buffer, 0)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.point.decrementY();
        }
        return false;
    }

    private boolean walkZ(BufferRetriever bufferRetriever) {
        if (this.point.isUseZ()) {
            return this.qualifyFromZDirection(bufferRetriever, -1) || this.qualifyFromZDirection(bufferRetriever, 1);
        }
        return false;
    }

    private boolean maybeQualifyFromBigNeighborhood(UnsignedByteBuffer buffer) {
        return this.bigNeighborhood && this.qualifyFromBigNeighborhood(buffer);
    }

    private boolean qualifyFromBigNeighborhood(UnsignedByteBuffer buffer) {
        this.point.decrementX();
        this.point.decrementY();
        if (this.testIf(this.point.nonNegativeX() && this.point.nonNegativeY(), () -> buffer, 0)) {
            this.point.incrementX();
            this.point.incrementY();
            return true;
        }
        this.point.incrementYTwice();
        if (this.testIf(this.point.nonNegativeX() && this.point.lessThanMaxY(), () -> buffer, 0)) {
            this.point.incrementX();
            this.point.decrementY();
            return true;
        }
        this.point.incrementXTwice();
        if (this.testIf(this.point.lessThanMaxX() && this.point.lessThanMaxY(), () -> buffer, 0)) {
            this.point.decrementX();
            this.point.decrementY();
            return true;
        }
        this.point.decrementYTwice();
        try {
            if (this.testIf(this.point.lessThanMaxX() && this.point.nonNegativeY(), () -> buffer, 0)) {
                boolean bl = true;
                return bl;
            }
        }
        finally {
            this.point.decrementX();
            this.point.incrementY();
        }
        return false;
    }

    private boolean qualifyFromZDirection(BufferRetriever bufferRetriever, int zShift) {
        Optional<UnsignedByteBuffer> buffer = bufferRetriever.getLocal(zShift);
        return this.testIf(buffer.isPresent(), buffer::get, zShift);
    }

    private boolean testIf(boolean inside, Supplier<UnsignedByteBuffer> buffer, int zShift) {
        return this.predicate.test(inside, this.point, buffer, zShift);
    }

    public WalkPredicate(KernelPointCursor point, NeighborPredicate predicate, boolean bigNeighborhood) {
        this.point = point;
        this.predicate = predicate;
        this.bigNeighborhood = bigNeighborhood;
    }
}

