/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.iterator.neighbor.kernel;

import java.util.Optional;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.kernel.BufferRetriever;
import org.anchoranalysis.image.voxel.kernel.KernelPointCursor;
import org.anchoranalysis.spatial.point.Point3i;

public class WalkRunnable {
    private final KernelPointCursor point;
    private final Predicate<Point3i> additionalPredicate;
    private final Runnable executeWhenSatisfied;

    public void walk(UnsignedByteBuffer buffer, BufferRetriever bufferRetriever) {
        this.walkX(buffer);
        this.walkY(buffer);
        if (this.point.isUseZ()) {
            this.walkZ(bufferRetriever);
        }
    }

    private void walkX(UnsignedByteBuffer buffer) {
        this.point.decrementX();
        this.executeIf(this.point.nonNegativeX(), () -> buffer);
        this.point.incrementXTwice();
        this.executeIf(this.point.lessThanMaxX(), () -> buffer);
        this.point.decrementX();
    }

    private void walkY(UnsignedByteBuffer buffer) {
        this.point.decrementY();
        this.executeIf(this.point.nonNegativeY(), () -> buffer);
        this.point.incrementYTwice();
        this.executeIf(this.point.lessThanMaxY(), () -> buffer);
        this.point.decrementY();
    }

    private void walkZ(BufferRetriever bufferRetriever) {
        this.point.decrementZ();
        this.executeIfZDirection(bufferRetriever, -1);
        this.point.incrementZTwice();
        this.executeIfZDirection(bufferRetriever, 1);
        this.point.decrementZ();
    }

    private void executeIfZDirection(BufferRetriever bufferRetriever, int zShift) {
        Optional<UnsignedByteBuffer> buffer = bufferRetriever.getLocal(zShift);
        this.executeIf(buffer.isPresent(), buffer::get);
    }

    private void executeIf(boolean inside, Supplier<UnsignedByteBuffer> buffer) {
        if (inside) {
            if (this.point.isBufferOff(buffer.get()) && this.additionalPredicate.test(this.point.getPoint())) {
                this.executeWhenSatisfied.run();
            }
        } else if (this.point.isOutsideOffUnignored() && this.additionalPredicate.test(this.point.getPoint())) {
            this.executeWhenSatisfied.run();
        }
    }

    public WalkRunnable(KernelPointCursor point, Predicate<Point3i> additionalPredicate, Runnable executeWhenSatisfied) {
        this.point = point;
        this.additionalPredicate = additionalPredicate;
        this.executeWhenSatisfied = executeWhenSatisfied;
    }
}

