/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.kernel;

import java.util.Optional;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.kernel.BufferRetriever;

public class LocalSlices
implements BufferRetriever {
    private final byte[][] array;
    private final int shift;

    public LocalSlices(int z, int windowSize, Voxels<UnsignedByteBuffer> voxels) {
        this.array = new byte[windowSize][];
        this.shift = (windowSize - 1) / 2;
        for (int i = 0; i < windowSize; ++i) {
            int rel = z + i - this.shift;
            this.array[i] = (byte[])(rel >= 0 && rel < voxels.extent().z() ? voxels.sliceBuffer(rel).array() : null);
        }
    }

    @Override
    public Optional<UnsignedByteBuffer> getLocal(int relativeZIndex) {
        int index = relativeZIndex + this.shift;
        if (index >= 0 && index < this.array.length) {
            byte[] slice = this.array[index];
            return Optional.ofNullable(slice).map(UnsignedByteBuffer::wrapRaw);
        }
        return Optional.empty();
    }
}

