/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.kernel;

import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;

public enum OutsideKernelPolicy {
    IGNORE_OUTSIDE(true, false),
    AS_ON(false, true),
    AS_OFF(false, false);

    private final boolean ignoreOutside;
    private final boolean outsideOn;

    public static OutsideKernelPolicy as(boolean on) {
        return on ? AS_ON : AS_OFF;
    }

    public static OutsideKernelPolicy of(boolean ignoreOutside, boolean outsideHigh) {
        if (ignoreOutside) {
            return IGNORE_OUTSIDE;
        }
        return OutsideKernelPolicy.as(outsideHigh);
    }

    public boolean isIgnoreOutside() {
        return this.ignoreOutside;
    }

    public boolean isOutsideOn() {
        return this.outsideOn;
    }

    public int multiplex(int ignored, int asOn, int asOff) {
        switch (this) {
            case IGNORE_OUTSIDE: {
                return ignored;
            }
            case AS_ON: {
                return asOn;
            }
            case AS_OFF: {
                return asOff;
            }
        }
        throw new AnchorImpossibleSituationException();
    }

    private OutsideKernelPolicy(boolean ignoreOutside, boolean outsideOn) {
        this.ignoreOutside = ignoreOutside;
        this.outsideOn = outsideOn;
    }
}

