/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.kernel.count;

import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.kernel.WalkRunnable;
import org.anchoranalysis.image.voxel.kernel.Kernel;
import org.anchoranalysis.image.voxel.kernel.KernelPointCursor;
import org.anchoranalysis.image.voxel.kernel.LocalSlices;
import org.anchoranalysis.math.arithmetic.Counter;
import org.anchoranalysis.spatial.point.Point3i;

public abstract class CountKernel
extends Kernel {
    private LocalSlices slices;

    protected CountKernel() {
        super(3);
    }

    @Override
    public void notifyBuffer(LocalSlices slices, int sliceIndex) {
        this.slices = slices;
    }

    public int calculateAt(KernelPointCursor point) {
        UnsignedByteBuffer buffer = this.slices.getLocal(0).get();
        if (point.isBufferOff(buffer)) {
            return 0;
        }
        Counter counter = new Counter();
        WalkRunnable walker = new WalkRunnable(point, this::doesNeighborVoxelQualify, () -> ((Counter)counter).increment());
        walker.walk(buffer, this.slices::getLocal);
        return counter.getCount();
    }

    protected abstract boolean doesNeighborVoxelQualify(Point3i var1);
}

