/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.object;

import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.axis.Axis;
import org.anchoranalysis.spatial.axis.AxisConverter;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3d;

final class CenterOfGravityCalculator {
    public static Point3d centerOfGravity(ObjectMask object) {
        int count = 0;
        Point3d sum = new Point3d();
        byte onByte = object.binaryValuesByte().getOn();
        Extent extent = object.extent();
        for (int z = 0; z < extent.z(); ++z) {
            UnsignedByteBuffer buffer = object.sliceBufferLocal(z);
            int offset = 0;
            for (int y = 0; y < extent.y(); ++y) {
                for (int x = 0; x < extent.x(); ++x) {
                    if (buffer.getRaw(offset) == onByte) {
                        sum.add((double)x, (double)y, (double)z);
                        ++count;
                    }
                    ++offset;
                }
            }
        }
        if (count == 0) {
            return CenterOfGravityCalculator.emptyPoint();
        }
        sum.divideBy(count);
        sum.add(object.boundingBox().cornerMin());
        return sum;
    }

    public static double centerOfGravityForAxis(ObjectMask object, Axis axis) {
        int count = 0;
        double sum = 0.0;
        byte onByte = object.binaryValuesByte().getOn();
        Extent extent = object.extent();
        for (int z = 0; z < extent.z(); ++z) {
            UnsignedByteBuffer buffer = object.sliceBufferLocal(z);
            int offset = 0;
            for (int y = 0; y < extent.y(); ++y) {
                for (int x = 0; x < extent.x(); ++x) {
                    if (buffer.getRaw(offset) == onByte) {
                        sum += (double)AxisConverter.valueFor((Axis)axis, (int)x, (int)y, (int)z);
                        ++count;
                    }
                    ++offset;
                }
            }
        }
        if (count == 0) {
            return Double.NaN;
        }
        return sum / (double)count + (double)object.boundingBox().cornerMin().valueByDimension(axis);
    }

    private static Point3d emptyPoint() {
        return new Point3d(Double.NaN, Double.NaN, Double.NaN);
    }

    private CenterOfGravityCalculator() {
    }
}

