/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.object;

import com.google.common.collect.Streams;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.function.IntFunction;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import org.anchoranalysis.core.functional.CheckedStream;
import org.anchoranalysis.core.functional.checked.CheckedBiFunction;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.functional.checked.CheckedIntFunction;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public class ObjectCollectionFactory {
    public static ObjectCollection empty() {
        return new ObjectCollection(Stream.empty());
    }

    @SafeVarargs
    public static ObjectCollection of(ObjectMask ... object) {
        return new ObjectCollection(Arrays.stream(object));
    }

    @SafeVarargs
    public static ObjectCollection of(ObjectCollection ... collection) {
        Stream<ObjectMask> stream = Arrays.stream(collection).flatMap(objects -> objects.streamStandardJava());
        return new ObjectCollection(stream);
    }

    @SafeVarargs
    public static ObjectCollection of(Optional<ObjectCollection> ... collections) {
        Stream<ObjectMask> stream = Arrays.stream(collections).filter(Optional::isPresent).map(Optional::get).flatMap(objects -> objects.streamStandardJava());
        return new ObjectCollection(stream);
    }

    @SafeVarargs
    public static ObjectCollection of(Collection<ObjectMask> ... collections) {
        Stream<ObjectMask> stream = Arrays.stream(collections).flatMap(objects -> objects.stream());
        return new ObjectCollection(stream);
    }

    public static <T> ObjectCollection mapFrom(Iterable<T> iterable, Function<T, ObjectMask> mapFunction) {
        Stream<T> streamIn = StreamSupport.stream(iterable.spliterator(), false);
        return new ObjectCollection(streamIn.map(mapFunction));
    }

    public static <T, E extends Exception> ObjectCollection mapFrom(Iterable<T> iterable, Class<? extends E> throwableClass, CheckedFunction<T, ObjectMask, E> mapFunction) throws E {
        Stream<T> streamIn = StreamSupport.stream(iterable.spliterator(), false);
        Stream streamConverted = CheckedStream.map(streamIn, throwableClass, mapFunction);
        return new ObjectCollection(streamConverted);
    }

    public static <T> ObjectCollection mapFromOptional(Iterable<T> iterable, Function<T, Optional<ObjectMask>> mapFunction) {
        return ObjectCollectionFactory.mapFromOptional(iterable.iterator(), mapFunction);
    }

    public static <T, E extends Exception> ObjectCollection mapFromOptional(Iterable<T> iterable, Class<? extends Exception> throwableClass, CheckedFunction<T, Optional<ObjectMask>, E> mapFunction) throws E {
        return ObjectCollectionFactory.mapFromOptional(iterable.iterator(), throwableClass, mapFunction);
    }

    public static <T> ObjectCollection mapFromOptional(Iterator<T> iterator, Function<T, Optional<ObjectMask>> mapFunction) {
        Stream<ObjectMask> stream = Streams.stream(iterator).map(mapFunction).filter(Optional::isPresent).map(Optional::get);
        return new ObjectCollection(stream);
    }

    public static <T, E extends Exception> ObjectCollection mapFromOptional(Iterator<T> iterator, Class<? extends Exception> throwableClass, CheckedFunction<T, Optional<ObjectMask>, E> mapFunction) throws E {
        Stream<ObjectMask> stream = CheckedStream.map((Stream)Streams.stream(iterator), throwableClass, mapFunction).filter(Optional::isPresent).map(Optional::get);
        return new ObjectCollection(stream);
    }

    @SafeVarargs
    public static ObjectCollection of(BinaryVoxels<UnsignedByteBuffer> ... masks) {
        Stream<ObjectMask> stream = Arrays.stream(masks).map(mask -> new ObjectMask((BinaryVoxels<UnsignedByteBuffer>)mask));
        return new ObjectCollection(stream);
    }

    public static ObjectCollection fromSet(Set<ObjectMask> set) {
        return new ObjectCollection(set.stream());
    }

    public static ObjectCollection fromRepeated(int repeats, Supplier<ObjectMask> createObjectMask) {
        return ObjectCollectionFactory.mapFromRange(0, repeats, index -> (ObjectMask)createObjectMask.get());
    }

    public static ObjectCollection mapFromRange(int startInclusive, int endExclusive, IntFunction<ObjectMask> mapFunction) {
        return new ObjectCollection(IntStream.range(startInclusive, endExclusive).mapToObj(mapFunction));
    }

    public static <E extends Exception> ObjectCollection mapFromRange(int startInclusive, int endExclusive, Class<? extends Exception> throwableClass, CheckedIntFunction<ObjectMask, E> mapFunction) throws E {
        return new ObjectCollection(CheckedStream.mapIntStream((IntStream)IntStream.range(startInclusive, endExclusive), throwableClass, mapFunction));
    }

    public static ObjectCollection flatMapFromRange(int startInclusive, int endExclusive, IntFunction<ObjectCollection> mapFunction) {
        return new ObjectCollection(IntStream.range(startInclusive, endExclusive).mapToObj(mapFunction).flatMap(ObjectCollection::streamStandardJava));
    }

    public static <E extends Exception> ObjectCollection flatMapFromRange(int startInclusive, int endExclusive, Class<? extends Exception> throwableClass, CheckedIntFunction<ObjectCollection, E> mapFunction) throws E {
        return new ObjectCollection(CheckedStream.mapIntStream((IntStream)IntStream.range(startInclusive, endExclusive), throwableClass, mapFunction).flatMap(ObjectCollection::streamStandardJava));
    }

    public static <T> ObjectCollection filterAndMapFrom(Collection<T> collection, Predicate<T> predicate, Function<T, ObjectMask> mapFunction) {
        Stream<ObjectMask> stream = collection.stream().filter(predicate).map(mapFunction);
        return new ObjectCollection(stream);
    }

    public static <T, E extends Exception> ObjectCollection filterAndMapFrom(Collection<T> collection, Predicate<T> predicate, Class<? extends E> throwableClass, CheckedFunction<T, ObjectMask, E> mapFunction) throws E {
        Stream stream = CheckedStream.map(collection.stream().filter(predicate), throwableClass, mapFunction);
        return new ObjectCollection(stream);
    }

    public static <T, E extends Exception> ObjectCollection filterAndMapWithIndexFrom(List<T> list, Predicate<T> predicate, Class<? extends E> throwableClass, CheckedBiFunction<T, Integer, ObjectMask, E> mapFunctionWithIndex) throws E {
        Stream stream = CheckedStream.mapToObj((IntStream)IntStream.range(0, list.size()), throwableClass, index -> {
            Object item = list.get(index);
            if (predicate.test(item)) {
                return Optional.of((ObjectMask)mapFunctionWithIndex.apply(item, (Object)index));
            }
            return Optional.empty();
        });
        return new ObjectCollection(stream.filter(Optional::isPresent).map(Optional::get));
    }

    public static <T> ObjectCollection flatMapFrom(Collection<T> collection, Function<T, ObjectCollection> mapFunction) {
        return new ObjectCollection(collection.stream().flatMap(t -> ((ObjectCollection)mapFunction.apply(t)).streamStandardJava()));
    }

    public static <T, E extends Exception> ObjectCollection flatMapFrom(Stream<T> stream, Class<? extends Exception> throwableClass, CheckedFunction<T, ObjectCollection, E> mapFunction) throws E {
        return ObjectCollectionFactory.flatMapFromCollection(stream, throwableClass, source -> ((ObjectCollection)mapFunction.apply(source)).streamStandardJava());
    }

    public static <T, E extends Exception> ObjectCollection flatMapFromStream(Stream<T> stream, Class<? extends Exception> throwableClass, CheckedFunction<T, Stream<ObjectMask>, E> mapFunction) throws E {
        return ObjectCollectionFactory.flatMapFromCollection(stream, throwableClass, source -> (Stream)mapFunction.apply(source));
    }

    public static <T, E extends Exception> ObjectCollection flatMapFromCollection(Stream<T> stream, Class<? extends Exception> throwableClass, CheckedFunction<T, Stream<? extends ObjectMask>, E> mapFunction) throws E {
        return new ObjectCollection(CheckedStream.flatMap(stream, throwableClass, mapFunction));
    }

    private ObjectCollectionFactory() {
    }
}

