/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.object;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.UnaryOperator;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.core.functional.OptionalFactory;
import org.anchoranalysis.image.voxel.BoundedVoxels;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.assigner.VoxelsAssigner;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsFactory;
import org.anchoranalysis.image.voxel.binary.connected.ObjectsFromConnectedComponentsFactory;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracter;
import org.anchoranalysis.image.voxel.extracter.predicate.VoxelsPredicate;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsEqualTo;
import org.anchoranalysis.image.voxel.iterator.intersecting.CountVoxelsIntersectingObjects;
import org.anchoranalysis.image.voxel.object.CenterOfGravityCalculator;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizerFactory;
import org.anchoranalysis.image.voxel.thresholder.VoxelsThresholder;
import org.anchoranalysis.spatial.axis.Axis;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3d;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class ObjectMask {
    private static final ObjectsFromConnectedComponentsFactory CONNECTED_COMPONENT_CREATOR = new ObjectsFromConnectedComponentsFactory(true);
    private static final VoxelsFactoryTypeBound<UnsignedByteBuffer> FACTORY = VoxelsFactory.getUnsignedByte();
    private final BoundedVoxels<UnsignedByteBuffer> voxels;
    private final BinaryValuesInt binaryValues;
    private final BinaryValuesByte binaryValuesByte;
    private final VoxelsResizer resizer;
    private final VoxelsExtracter<UnsignedByteBuffer> extract;

    public ObjectMask(Voxels<UnsignedByteBuffer> voxels) {
        this(new BoundedVoxels<UnsignedByteBuffer>(voxels));
    }

    public ObjectMask(BoundingBox box) {
        this(VoxelsFactory.getUnsignedByte().createBounded(box));
    }

    public ObjectMask(BoundedVoxels<UnsignedByteBuffer> voxels) {
        this(voxels, BinaryValuesInt.getDefault());
    }

    public ObjectMask(BinaryVoxels<UnsignedByteBuffer> voxels) {
        this(new BoundedVoxels<UnsignedByteBuffer>(voxels.voxels()), voxels.binaryValues());
    }

    public ObjectMask(BoundingBox box, Voxels<UnsignedByteBuffer> voxels) {
        this(new BoundedVoxels<UnsignedByteBuffer>(box, voxels));
    }

    public ObjectMask(BoundingBox box, Voxels<UnsignedByteBuffer> voxels, BinaryValuesInt binaryValues) {
        this(new BoundedVoxels<UnsignedByteBuffer>(box, voxels), binaryValues);
    }

    public ObjectMask(BoundingBox box, BinaryVoxels<UnsignedByteBuffer> voxels) {
        this(new BoundedVoxels<UnsignedByteBuffer>(box, voxels.voxels()), voxels.binaryValues());
    }

    public ObjectMask(BoundedVoxels<UnsignedByteBuffer> voxels, BinaryValuesInt binaryValues) {
        this.voxels = voxels;
        this.binaryValues = binaryValues;
        this.binaryValuesByte = binaryValues.asByte();
        this.resizer = this.createResizer(binaryValues);
        this.extract = voxels.extract();
    }

    public ObjectMask(BoundingBox box, Voxels<UnsignedByteBuffer> voxels, BinaryValuesByte binaryValues) {
        this.voxels = new BoundedVoxels<UnsignedByteBuffer>(box, voxels);
        this.binaryValues = binaryValues.asInt();
        this.binaryValuesByte = binaryValues;
        this.resizer = this.createResizer(this.binaryValues);
        this.extract = voxels.extract();
    }

    private ObjectMask(ObjectMask source) {
        this(new BoundedVoxels<UnsignedByteBuffer>(source.voxels), source.binaryValues, source.binaryValuesByte);
    }

    private ObjectMask(BoundedVoxels<UnsignedByteBuffer> voxels, BinaryValuesInt binaryValues, BinaryValuesByte binaryValuesByte) {
        this.voxels = voxels;
        this.binaryValues = binaryValues;
        this.binaryValuesByte = binaryValuesByte;
        this.resizer = this.createResizer(binaryValues);
        this.extract = voxels.extract();
    }

    public ObjectMask duplicate() {
        return new ObjectMask(this);
    }

    public ObjectMask replaceVoxels(Voxels<UnsignedByteBuffer> voxelsToAssign) {
        return new ObjectMask(this.voxels.replaceVoxels(voxelsToAssign), this.binaryValues);
    }

    public ObjectMask growToZ(int sizeZ) throws OperationFailedException {
        return new ObjectMask(this.voxels.growToZ(sizeZ, FACTORY));
    }

    public ObjectMask growBuffer(Point3i growthNegative, Point3i growthPositive, Optional<Extent> clipRegion) throws OperationFailedException {
        return new ObjectMask(this.voxels.growBuffer(growthNegative, growthPositive, clipRegion, FACTORY));
    }

    public boolean equalsDeep(ObjectMask other) {
        if (!this.voxels.equalsDeep(other.voxels)) {
            return false;
        }
        if (!this.binaryValues.equals(other.binaryValues)) {
            return false;
        }
        return this.binaryValuesByte.equals(other.binaryValuesByte);
    }

    public int countIntersectingVoxels(ObjectMask other) {
        return CountVoxelsIntersectingObjects.countIntersectingVoxels(this, other);
    }

    public boolean hasIntersectingVoxels(ObjectMask other) {
        return CountVoxelsIntersectingObjects.hasIntersectingVoxels(this, other);
    }

    public ObjectMask scale(ScaleFactor factor) {
        return this.scale(factor, Optional.empty());
    }

    public ObjectMask invert() {
        return new ObjectMask(this.voxels, this.binaryValues.createInverted());
    }

    public ObjectMask scale(ScaleFactor factor, Optional<Extent> clipTo) {
        if (this.binaryValues.getOn() == 255 && this.binaryValues.getOff() == 0 || this.binaryValues.getOn() == 0 && this.binaryValues.getOff() == 255) {
            BoundedVoxels<UnsignedByteBuffer> scaled = this.voxels.scale(factor, this.resizer, clipTo);
            if (this.resizer.canValueRangeChange()) {
                int thresholdVal = (this.binaryValues.getOn() + this.binaryValues.getOff()) / 2;
                VoxelsThresholder.thresholdByte(scaled.voxels(), thresholdVal, this.binaryValues.asByte());
            }
            return new ObjectMask(scaled, this.binaryValues);
        }
        throw new AnchorFriendlyRuntimeException("Operation not supported for these binary values");
    }

    public ObjectMask clampTo(Extent extent) {
        if (extent.contains(this.boundingBox())) {
            return this;
        }
        BoundingBox clippedBox = this.boundingBox().clampTo(extent);
        return this.mapBoundingBoxChangeExtent(clippedBox);
    }

    public Point3d centerOfGravity() {
        return CenterOfGravityCalculator.centerOfGravity(this);
    }

    public double centerOfGravity(Axis axis) {
        return CenterOfGravityCalculator.centerOfGravityForAxis(this, axis);
    }

    public boolean checkIfConnected() {
        ObjectCollection objects = CONNECTED_COMPONENT_CREATOR.createUnsignedByte(this.binaryVoxels().duplicate());
        return objects.size() <= 1;
    }

    public VoxelsPredicate voxelsOn() {
        return this.extract.voxelsEqualTo(this.binaryValues.getOn());
    }

    public VoxelsPredicate voxelsOff() {
        return this.extract.voxelsEqualTo(this.binaryValues.getOff());
    }

    public int numberVoxelsOn() {
        return this.voxelsOn().count();
    }

    public Optional<ObjectMask> intersect(ObjectMask other, Extent extent) {
        Optional boxIntersect = this.boundingBox().intersection().withInside(other.boundingBox(), extent);
        if (!boxIntersect.isPresent()) {
            return Optional.empty();
        }
        BinaryValuesInt binaryValuesOut = BinaryValuesInt.getDefault();
        BoundedVoxels<UnsignedByteBuffer> voxelsMaskOut = VoxelsFactory.getUnsignedByte().createBounded((BoundingBox)boxIntersect.get());
        voxelsMaskOut.assignValue(binaryValuesOut.getOn()).toAll();
        voxelsMaskOut.assignValue(binaryValuesOut.getOff()).toEitherTwoObjects(this.invert(), other.invert(), (BoundingBox)boxIntersect.get());
        ObjectMask object = new ObjectMask(voxelsMaskOut, binaryValuesOut);
        return OptionalFactory.create((boolean)object.voxelsOn().anyExists(), (Object)object);
    }

    public boolean contains(Point3i point) {
        if (this.voxels.boundingBox().contains().point((ReadableTuple3i)point)) {
            return this.extract.voxel((ReadableTuple3i)point) == this.binaryValues.getOn();
        }
        return false;
    }

    public ObjectMask flattenZ() {
        return new ObjectMask(this.voxels.projectMax());
    }

    public BoundingBox boundingBox() {
        return this.voxels.boundingBox();
    }

    public BinaryVoxels<UnsignedByteBuffer> binaryVoxels() {
        return BinaryVoxelsFactory.reuseByte(this.voxels.voxels(), this.binaryValues);
    }

    public Voxels<UnsignedByteBuffer> voxels() {
        return this.voxels.voxels();
    }

    public BoundedVoxels<UnsignedByteBuffer> boundedVoxels() {
        return this.voxels;
    }

    public Extent extent() {
        return this.voxels.extent();
    }

    public int offsetRelative(int x, int y) {
        return this.voxels.extent().offset(x, y);
    }

    public int offsetGlobal(int x, int y) {
        return this.offsetRelative(x - this.boundingBox().cornerMin().x(), y - this.boundingBox().cornerMin().y());
    }

    public ObjectMask extractSlice(int sliceIndex, boolean keepIndex) {
        ObjectMask slice = new ObjectMask(this.voxels.extractSlice(sliceIndex), this.binaryValues);
        if (keepIndex) {
            return slice.mapBoundingBoxPreserveExtent(box -> box.shiftToZ(sliceIndex));
        }
        return slice;
    }

    public ObjectMask regionZ(int zMin, int zMax) throws CreateException {
        return new ObjectMask(this.voxels.regionZ(zMin, zMax, FACTORY), this.binaryValues);
    }

    public ObjectMask region(BoundingBox box, boolean reuseIfPossible) throws CreateException {
        return new ObjectMask(this.voxels.region(box, reuseIfPossible), this.binaryValues);
    }

    public ObjectMask regionIntersecting(BoundingBox box) throws CreateException {
        return new ObjectMask(this.voxels.regionIntersecting(box, this.binaryValues.getOff()), this.binaryValues);
    }

    public Optional<Point3i> findArbitraryOnVoxel() {
        Point3i point = this.boundingBox().centerOfGravity();
        if (this.contains(point)) {
            return Optional.of(point);
        }
        return IterateVoxelsEqualTo.untilFirstIntensityEqualTo(this.boundedVoxels(), this.binaryValuesByte().getOn());
    }

    public UnsignedByteBuffer sliceBufferLocal(int sliceIndexRelative) {
        return this.voxels.sliceBufferLocal(sliceIndexRelative);
    }

    public UnsignedByteBuffer sliceBufferGlobal(int sliceIndexGlobal) {
        return this.voxels.sliceBufferGlobal(sliceIndexGlobal);
    }

    public ObjectMask shiftToOrigin() {
        return this.mapBoundingBoxPreserveExtent(BoundingBox::shiftToOrigin);
    }

    public ObjectMask shiftBy(ReadableTuple3i shift) {
        return this.mapBoundingBoxPreserveExtent(box -> box.shiftBy(shift));
    }

    public ObjectMask shiftBackBy(ReadableTuple3i shift) {
        return this.mapBoundingBoxPreserveExtent(box -> box.shiftBackBy(shift));
    }

    public ObjectMask mapBoundingBoxPreserveExtent(UnaryOperator<BoundingBox> mapOperation) {
        return this.mapBoundingBoxPreserveExtent((BoundingBox)mapOperation.apply(this.voxels.boundingBox()));
    }

    public ObjectMask mapBoundingBoxChangeExtent(BoundingBox boxToAssign) {
        Preconditions.checkArgument((!boxToAssign.extent().anyDimensionIsLargerThan(this.voxels.extent()) ? 1 : 0) != 0);
        if (this.voxels.boundingBox().equals((Object)boxToAssign)) {
            return this;
        }
        if (this.voxels.boundingBox().equals((Object)boxToAssign)) {
            return this.mapBoundingBoxPreserveExtent(boxToAssign);
        }
        Voxels<UnsignedByteBuffer> voxelsLarge = VoxelsFactory.getUnsignedByte().createInitialized(boxToAssign.extent());
        BoundingBox bbLocal = this.voxels.boundingBox().relativePositionToBox(boxToAssign);
        voxelsLarge.assignValue(this.binaryValuesByte.getOn()).toObject(new ObjectMask(bbLocal, this.binaryVoxels()));
        return new ObjectMask(boxToAssign, voxelsLarge, this.binaryValuesByte);
    }

    public ObjectMask relativeMaskTo(BoundingBox box) {
        Point3i point = this.voxels.boundingBox().relativePositionTo(box);
        return new ObjectMask(BoundingBox.createReuse((ReadableTuple3i)point, (Extent)this.voxels.extent()), this.voxels.voxels());
    }

    public VoxelsAssigner assignOn() {
        return this.voxels.assignValue(this.binaryValues.getOn());
    }

    public VoxelsAssigner assignOff() {
        return this.voxels.assignValue(this.binaryValues.getOff());
    }

    public List<Point3i> derivePointsLocal() {
        ArrayList<Point3i> points = new ArrayList<Point3i>();
        IterateVoxelsEqualTo.equalToPrimitive(this.voxels.voxels(), this.binaryValuesByte().getOn(), (x, y, z) -> points.add(new Point3i(x, y, z)));
        return points;
    }

    public String toString() {
        return String.format("Obj%s(cog=%s,numPixels=%d)", super.hashCode(), this.centerOfGravity().toString(), this.numberVoxelsOn());
    }

    private VoxelsResizer createResizer(BinaryValuesInt binaryValues) {
        return VoxelsResizerFactory.getInstance().binaryResizer(binaryValues.getOff());
    }

    private ObjectMask mapBoundingBoxPreserveExtent(BoundingBox boundingBoxToAssign) {
        return new ObjectMask(this.voxels.mapBoundingBoxPreserveExtent(boundingBoxToAssign), this.binaryValues, this.binaryValuesByte);
    }

    public BinaryValuesInt binaryValues() {
        return this.binaryValues;
    }

    public BinaryValuesByte binaryValuesByte() {
        return this.binaryValuesByte;
    }

    public VoxelsExtracter<UnsignedByteBuffer> extract() {
        return this.extract;
    }
}

