/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.ToIntFunction;
import java.util.function.UnaryOperator;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.anchoranalysis.core.functional.CheckedStream;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.core.functional.checked.CheckedPredicate;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;

public final class ObjectMaskStream {
    private ObjectCollection delegate;

    public <E extends Exception> ObjectCollection map(CheckedFunction<ObjectMask, ObjectMask, E> mapFunction) throws E {
        ArrayList<ObjectMask> list = new ArrayList<ObjectMask>(this.delegate.size());
        for (ObjectMask object : this.delegate) {
            list.add((ObjectMask)mapFunction.apply((Object)object));
        }
        return new ObjectCollection(list);
    }

    public ObjectCollection mapBoundingBoxPreserveExtent(UnaryOperator<BoundingBox> mapFunction) {
        return this.map(object -> object.mapBoundingBoxPreserveExtent(mapFunction));
    }

    public ObjectCollection mapBoundingBoxChangeExtent(BoundingBox boxToAssign) {
        return this.map(object -> object.mapBoundingBoxChangeExtent(boxToAssign));
    }

    public <T, E extends Exception> List<T> mapToList(CheckedFunction<ObjectMask, T, E> mapFunction) throws E {
        ArrayList<Object> out = new ArrayList<Object>();
        for (ObjectMask obj : this.delegate) {
            out.add(mapFunction.apply((Object)obj));
        }
        return out;
    }

    public <T, E extends Exception> List<T> mapToListOptional(CheckedFunction<ObjectMask, Optional<T>, E> mapFunction) throws E {
        ArrayList out = new ArrayList(this.delegate.size());
        for (ObjectMask obj : this.delegate) {
            Optional result = (Optional)mapFunction.apply((Object)obj);
            result.ifPresent(out::add);
        }
        return out;
    }

    public <T, E extends Exception> SortedSet<T> mapToSortedSet(CheckedFunction<ObjectMask, T, E> mapFunction) throws E {
        TreeSet<Object> out = new TreeSet<Object>();
        for (ObjectMask obj : this.delegate) {
            out.add(mapFunction.apply((Object)obj));
        }
        return out;
    }

    public ObjectCollection flatMap(Function<ObjectMask, ObjectCollection> mapFunction) {
        return new ObjectCollection(this.delegate.streamStandardJava().flatMap((? super T element) -> ((ObjectCollection)mapFunction.apply((ObjectMask)element)).streamStandardJava()));
    }

    public <E extends Exception> ObjectCollection flatMap(Class<? extends Exception> throwableClass, CheckedFunction<ObjectMask, ObjectCollection, E> mapFunction) throws E {
        return new ObjectCollection(CheckedStream.flatMap(this.delegate.streamStandardJava(), throwableClass, element -> ((ObjectCollection)mapFunction.apply(element)).streamStandardJava()));
    }

    public ObjectCollection filter(Predicate<ObjectMask> predicate) {
        return new ObjectCollection(this.delegate.streamStandardJava().filter(predicate));
    }

    public <E extends Exception> ObjectCollection filter(CheckedPredicate<ObjectMask, E> predicate, Class<? extends Exception> throwableClass) throws E {
        Stream stream = CheckedStream.filter(this.delegate.streamStandardJava(), throwableClass, predicate);
        return new ObjectCollection(stream);
    }

    public ObjectCollection filterExclude(Predicate<ObjectMask> predicate) {
        return this.filter(object -> !predicate.test((ObjectMask)object));
    }

    public ObjectCollection filterAndMap(Predicate<ObjectMask> predicate, UnaryOperator<ObjectMask> mapFunction) {
        return new ObjectCollection(this.delegate.streamStandardJava().filter(predicate).map(mapFunction));
    }

    public ObjectCollection filterSubset(Predicate<ObjectMask> predicate, Collection<Integer> indices) {
        return new ObjectCollection(this.filterSubsetStream(predicate, indices));
    }

    public Stream<ObjectMask> filterSubsetStream(Predicate<ObjectMask> predicate, Collection<Integer> indices) {
        return this.delegate.streamIndices(indices).filter(predicate);
    }

    public boolean anyMatch(Predicate<ObjectMask> predicate) {
        return this.delegate.streamStandardJava().anyMatch(predicate);
    }

    public Set<ObjectMask> toSet() {
        return this.delegate.streamStandardJava().collect(Collectors.toCollection(HashSet::new));
    }

    public OptionalInt maxAsInt(ToIntFunction<ObjectMask> function) {
        return this.delegate.streamStandardJava().mapToInt(function).max();
    }

    public OptionalInt minAsInt(ToIntFunction<ObjectMask> function) {
        return this.delegate.streamStandardJava().mapToInt(function).min();
    }

    public ObjectMaskStream(ObjectCollection delegate) {
        this.delegate = delegate;
    }
}

