/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.object.morphological;

import java.util.Optional;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.HasFriendlyErrorMessage;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.kernel.ApplyKernel;
import org.anchoranalysis.image.voxel.kernel.BinaryKernel;
import org.anchoranalysis.image.voxel.kernel.OutsideKernelPolicy;
import org.anchoranalysis.image.voxel.kernel.morphological.DilationContext;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.object.morphological.predicate.AcceptIterationPredicate;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;

public class MorphologicalDilation {
    public static ObjectMask dilate(ObjectMask object, Optional<Extent> extent, boolean useZ, int iterations, boolean bigNeighborhood) throws CreateException {
        Point3i grow = useZ ? new Point3i(iterations, iterations, iterations) : new Point3i(iterations, iterations, 0);
        DilationContext context = new DilationContext(OutsideKernelPolicy.IGNORE_OUTSIDE, useZ, bigNeighborhood, Optional.empty());
        try {
            ObjectMask objectGrown = object.growBuffer(grow, grow, extent);
            BinaryVoxels<UnsignedByteBuffer> dilated = MorphologicalDilation.dilate(objectGrown.binaryVoxels(), iterations, context);
            return objectGrown.replaceVoxels(dilated.voxels());
        }
        catch (OperationFailedException e) {
            throw new CreateException("Cannot grow object-mask", (HasFriendlyErrorMessage)e);
        }
    }

    public static BinaryVoxels<UnsignedByteBuffer> dilate(BinaryVoxels<UnsignedByteBuffer> voxels, int iterations, DilationContext context) throws CreateException {
        BinaryKernel kernel = context.createKernel();
        Optional<AcceptIterationPredicate> postcondition = context.getPostcondition();
        for (int i = 0; i < iterations; ++i) {
            BinaryVoxels<UnsignedByteBuffer> next = ApplyKernel.apply(kernel, voxels, context.getKernelApplication());
            try {
                if (postcondition.isPresent() && !postcondition.get().accept(next)) {
                    break;
                }
            }
            catch (OperationFailedException e) {
                throw new CreateException((Throwable)e);
            }
            voxels = next;
        }
        return voxels;
    }

    private MorphologicalDilation() {
    }
}

