/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.object.morphological;

import java.util.Optional;
import java.util.function.Predicate;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.kernel.OutsideKernelPolicy;
import org.anchoranalysis.image.voxel.kernel.morphological.DilationContext;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.object.morphological.MorphologicalDilation;
import org.anchoranalysis.image.voxel.object.morphological.predicate.AcceptIterationPredicate;
import org.anchoranalysis.spatial.point.Point3i;

public class MorphologicalErosion {
    public static ObjectMask erode(ObjectMask object, int iterations, boolean useZ) throws CreateException {
        return MorphologicalErosion.erode(object, iterations, useZ, Optional.empty());
    }

    public static ObjectMask erode(ObjectMask object, int iterations, boolean useZ, Optional<AcceptIterationPredicate> postcondition) throws CreateException {
        ObjectMask objectOut = object.duplicate();
        BinaryVoxels<UnsignedByteBuffer> eroded = MorphologicalErosion.erodeInternal(objectOut.binaryVoxels(), iterations, useZ, Optional.empty(), postcondition);
        return objectOut.replaceVoxels(eroded.voxels());
    }

    public static BinaryVoxels<UnsignedByteBuffer> erode(BinaryVoxels<UnsignedByteBuffer> voxels, int iterations, boolean useZ, Optional<Predicate<Point3i>> precondition) throws CreateException {
        return MorphologicalErosion.erodeInternal(voxels, iterations, useZ, precondition, Optional.empty());
    }

    private static BinaryVoxels<UnsignedByteBuffer> erodeInternal(BinaryVoxels<UnsignedByteBuffer> voxels, int iterations, boolean useZ, Optional<Predicate<Point3i>> precondition, Optional<AcceptIterationPredicate> postcondition) throws CreateException {
        DilationContext context = new DilationContext(OutsideKernelPolicy.AS_ON, useZ, false, precondition, postcondition);
        voxels.invert();
        BinaryVoxels<UnsignedByteBuffer> dilated = MorphologicalDilation.dilate(voxels, iterations, context);
        dilated.invert();
        return dilated;
    }

    private MorphologicalErosion() {
    }
}

