/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.convert.VoxelsConverterMulti;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;
import org.anchoranalysis.spatial.box.Extent;

class MeanIntensityBuffer<T>
implements ProjectableBuffer<T> {
    private static final VoxelsConverterMulti CONVERTER = new VoxelsConverterMulti();
    private Voxels<FloatBuffer> voxelsSum;
    private int count = 0;
    private final VoxelsFactoryTypeBound<T> factory;

    public MeanIntensityBuffer(VoxelsFactoryTypeBound<T> factory, Extent extent) {
        this.factory = factory;
        this.voxelsSum = VoxelsFactory.getFloat().createInitialized(extent);
    }

    @Override
    public void addVoxelBuffer(VoxelBuffer<T> voxelBuffer) {
        this.addVoxelBufferInternal(voxelBuffer, 0);
        ++this.count;
    }

    @Override
    public void addVoxels(Voxels<T> voxels) {
        for (int z = 0; z < voxels.extent().z(); ++z) {
            this.addVoxelBufferInternal(voxels.slice(z), z);
        }
        ++this.count;
    }

    @Override
    public Voxels<T> completeProjection() {
        this.voxelsSum.arithmetic().divideBy(this.count);
        return CONVERTER.convert(new VoxelsUntyped(this.voxelsSum), this.factory);
    }

    private void addVoxelBufferInternal(VoxelBuffer<T> voxelBuffer, int z) {
        FloatBuffer sumBuffer = this.voxelsSum.sliceBuffer(z);
        this.voxelsSum.extent().iterateOverXYOffset(offset -> this.incrementSumBuffer(offset, voxelBuffer.getInt(offset), sumBuffer));
    }

    private void incrementSumBuffer(int index, int toAdd, FloatBuffer sumBuffer) {
        sumBuffer.put(index, sumBuffer.get(index) + (float)toAdd);
    }
}

