/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection;

import java.nio.FloatBuffer;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedIntVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.projection.MeanIntensityBuffer;
import org.anchoranalysis.spatial.box.Extent;

public class MeanIntensityProjection {
    public static <T> ProjectableBuffer<T> create(VoxelDataType dataType, Extent extent) throws OperationFailedException {
        if (dataType.equals(UnsignedByteVoxelType.INSTANCE)) {
            return MeanIntensityProjection.createUnsignedByte(extent);
        }
        if (dataType.equals(UnsignedShortVoxelType.INSTANCE)) {
            return MeanIntensityProjection.createUnsignedShort(extent);
        }
        if (dataType.equals(UnsignedIntVoxelType.INSTANCE)) {
            return MeanIntensityProjection.createUnsignedInt(extent);
        }
        if (dataType.equals(FloatVoxelType.INSTANCE)) {
            return MeanIntensityProjection.createFloat(extent);
        }
        throw new OperationFailedException("No maximum-intensity projection buffer can be created, as voxel-data-type is unsupported: " + dataType.toString());
    }

    public static ProjectableBuffer<UnsignedByteBuffer> createUnsignedByte(Extent extent) {
        return new MeanIntensityBuffer<UnsignedByteBuffer>(VoxelsFactory.getUnsignedByte(), extent);
    }

    public static ProjectableBuffer<UnsignedShortBuffer> createUnsignedShort(Extent extent) {
        return new MeanIntensityBuffer<UnsignedShortBuffer>(VoxelsFactory.getUnsignedShort(), extent);
    }

    public static ProjectableBuffer<UnsignedIntBuffer> createUnsignedInt(Extent extent) {
        return new MeanIntensityBuffer<UnsignedIntBuffer>(VoxelsFactory.getUnsignedInt(), extent);
    }

    public static ProjectableBuffer<FloatBuffer> createFloat(Extent extent) {
        return new MeanIntensityBuffer<FloatBuffer>(VoxelsFactory.getFloat(), extent);
    }

    private MeanIntensityProjection() {
    }
}

