/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.convert.VoxelsConverterMulti;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;
import org.anchoranalysis.spatial.box.Extent;

class StandardDeviationIntensityBuffer<T>
implements ProjectableBuffer<T> {
    private static final VoxelsConverterMulti CONVERTER = new VoxelsConverterMulti();
    private Voxels<FloatBuffer> voxelsSum;
    private Voxels<FloatBuffer> voxelsSumSquared;
    private int count = 0;
    private final VoxelsFactoryTypeBound<T> flatType;

    public StandardDeviationIntensityBuffer(VoxelsFactoryTypeBound<T> flatType, Extent extent) {
        this.flatType = flatType;
        this.voxelsSum = VoxelsFactory.getFloat().createInitialized(extent);
        this.voxelsSumSquared = VoxelsFactory.getFloat().createInitialized(extent);
    }

    @Override
    public void addVoxelBuffer(VoxelBuffer<T> voxelBuffer) {
        this.addVoxelBufferInternal(voxelBuffer, 0);
        ++this.count;
    }

    @Override
    public void addVoxels(Voxels<T> voxels) {
        for (int z = 0; z < voxels.extent().z(); ++z) {
            this.addVoxelBufferInternal(voxels.slice(z), z);
        }
        ++this.count;
    }

    @Override
    public Voxels<T> completeProjection() {
        this.voxelsSum.arithmetic().divideBy(this.count);
        this.voxelsSumSquared.arithmetic().divideBy(this.count);
        StandardDeviationIntensityBuffer.squareEachVoxel(this.voxelsSum);
        StandardDeviationIntensityBuffer.subtractSquareRoot(this.voxelsSumSquared, this.voxelsSum);
        return CONVERTER.convert(new VoxelsUntyped(this.voxelsSumSquared), this.flatType);
    }

    private void addVoxelBufferInternal(VoxelBuffer<T> voxelBuffer, int z) {
        FloatBuffer sumBuffer = this.voxelsSum.sliceBuffer(z);
        FloatBuffer sumSquaredBuffer = this.voxelsSumSquared.sliceBuffer(z);
        this.voxelsSum.extent().iterateOverXYOffset(offset -> this.incrementSumBuffer(offset, voxelBuffer.getInt(offset), sumBuffer, sumSquaredBuffer));
    }

    private void incrementSumBuffer(int index, int toAdd, FloatBuffer sumBuffer, FloatBuffer sumSquaredBuffer) {
        StandardDeviationIntensityBuffer.addToPosition(sumBuffer, index, toAdd);
        StandardDeviationIntensityBuffer.addToPosition(sumSquaredBuffer, index, toAdd * toAdd);
    }

    private static void addToPosition(FloatBuffer buffer, int index, int toAdd) {
        buffer.put(index, buffer.get(index) + (float)toAdd);
    }

    private static void squareEachVoxel(Voxels<FloatBuffer> voxelsBuffer) {
        for (int z = 0; z < voxelsBuffer.extent().z(); ++z) {
            FloatBuffer buffer = voxelsBuffer.sliceBuffer(z);
            buffer.rewind();
            while (buffer.hasRemaining()) {
                float value = buffer.get();
                buffer.position(buffer.position() - 1);
                buffer.put(value * value);
            }
        }
    }

    private static void subtractSquareRoot(Voxels<FloatBuffer> voxelsBufferBigger, Voxels<FloatBuffer> voxelsBufferSmaller) {
        for (int z = 0; z < voxelsBufferBigger.extent().z(); ++z) {
            FloatBuffer bufferBigger = voxelsBufferBigger.sliceBuffer(z);
            FloatBuffer bufferSmaller = voxelsBufferSmaller.sliceBuffer(z);
            bufferBigger.rewind();
            bufferSmaller.rewind();
            while (bufferBigger.hasRemaining()) {
                float bigger = bufferBigger.get();
                float smaller = bufferSmaller.get();
                float valueToAssign = (float)Math.sqrt(bigger - smaller);
                bufferBigger.position(bufferBigger.position() - 1);
                bufferBigger.put(valueToAssign);
            }
        }
    }
}

