/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection.extrema;

import java.nio.FloatBuffer;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedIntVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.image.voxel.projection.extrema.FloatImplementation;
import org.anchoranalysis.image.voxel.projection.extrema.UnsignedByteImplementation;
import org.anchoranalysis.image.voxel.projection.extrema.UnsignedIntImplementation;
import org.anchoranalysis.image.voxel.projection.extrema.UnsignedShortImplementation;
import org.anchoranalysis.spatial.box.Extent;

public class MinIntensityProjection {
    public static <T> ProjectableBuffer<T> create(VoxelDataType dataType, Extent extent) throws OperationFailedException {
        if (dataType.equals(UnsignedByteVoxelType.INSTANCE)) {
            return MinIntensityProjection.createUnsignedByte(extent);
        }
        if (dataType.equals(UnsignedShortVoxelType.INSTANCE)) {
            return MinIntensityProjection.createUnsignedShort(extent);
        }
        if (dataType.equals(UnsignedIntVoxelType.INSTANCE)) {
            return MinIntensityProjection.createUnsignedInt(extent);
        }
        if (dataType.equals(FloatVoxelType.INSTANCE)) {
            return MinIntensityProjection.createFloat(extent);
        }
        throw new OperationFailedException("No minimum-intensity projection buffer can be created, as voxel-data-type is unsupported: " + dataType.toString());
    }

    public static ProjectableBuffer<UnsignedByteBuffer> createUnsignedByte(Extent extent) {
        return new UnsignedByteImplementation(extent, MinIntensityProjection::isValueLessThanExistingInt);
    }

    public static ProjectableBuffer<UnsignedShortBuffer> createUnsignedShort(Extent extent) {
        return new UnsignedShortImplementation(extent, MinIntensityProjection::isValueLessThanExistingInt);
    }

    public static ProjectableBuffer<UnsignedIntBuffer> createUnsignedInt(Extent extent) {
        return new UnsignedIntImplementation(extent, MinIntensityProjection::isValueLessThanExistingLong);
    }

    public static ProjectableBuffer<FloatBuffer> createFloat(Extent extent) {
        return new FloatImplementation(extent, MinIntensityProjection::isValueLessThanExistingFloat);
    }

    private static boolean isValueLessThanExistingInt(int value, int existing) {
        return value < existing;
    }

    private static boolean isValueLessThanExistingLong(long value, long existing) {
        return value < existing;
    }

    private static boolean isValueLessThanExistingFloat(float value, float existing) {
        return value < existing;
    }

    private MinIntensityProjection() {
    }
}

