/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.resizer;

import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.IncorrectVoxelTypeException;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.resizer.TransferViaSpecificType;

class ResizeHelper {
    static TransferViaSpecificType<?> createTransfer(VoxelsUntyped source, VoxelsUntyped destination) {
        if (!source.getVoxelDataType().equals(destination.getVoxelDataType())) {
            throw new IncorrectVoxelTypeException("Data types don't match between source and destination");
        }
        if (source.getVoxelDataType().equals(UnsignedByteVoxelType.INSTANCE)) {
            return new TransferViaSpecificType(source, destination, VoxelsUntyped::asByte, (interpolator, voxelsSource, voxelsDestination, extentSource, extentDestination) -> interpolator.resizeByte(voxelsSource, voxelsDestination, extentSource, extentDestination));
        }
        if (source.getVoxelDataType().equals(UnsignedShortVoxelType.INSTANCE)) {
            return new TransferViaSpecificType(source, destination, VoxelsUntyped::asShort, (interpolator, voxelsSource, voxelsDestination, extentSource, extentDestination) -> interpolator.resizeShort(voxelsSource, voxelsDestination, extentSource, extentDestination));
        }
        if (source.getVoxelDataType().equals(FloatVoxelType.INSTANCE)) {
            return new TransferViaSpecificType(source, destination, VoxelsUntyped::asFloat, (interpolator, voxelsSource, voxelsDestination, extentSource, extentDestination) -> interpolator.resizeFloat(voxelsSource, voxelsDestination, extentSource, extentDestination));
        }
        throw new IncorrectVoxelTypeException("Only unsigned byte and short and float are supported");
    }

    private ResizeHelper() {
    }
}

