/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.resizer;

import java.nio.FloatBuffer;
import net.imglib2.Cursor;
import net.imglib2.RandomAccessible;
import net.imglib2.RealRandomAccess;
import net.imglib2.RealRandomAccessible;
import net.imglib2.img.Img;
import net.imglib2.interpolation.InterpolatorFactory;
import net.imglib2.type.Type;
import net.imglib2.type.numeric.integer.UnsignedByteType;
import net.imglib2.type.numeric.integer.UnsignedShortType;
import net.imglib2.type.numeric.real.AbstractRealType;
import net.imglib2.type.numeric.real.FloatType;
import net.imglib2.view.ExtendedRandomAccessibleInterval;
import net.imglib2.view.Views;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.convert.imglib2.ConvertToImg;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.box.Extent;

public abstract class VoxelsResizerImgLib2
extends VoxelsResizer {
    private static final double SHIFT_IN_INTERPOLATED_POSITION = -0.5;
    private final InterpolatorFactory<UnsignedByteType, RandomAccessible<UnsignedByteType>> factoryByte;
    private final InterpolatorFactory<UnsignedShortType, RandomAccessible<UnsignedShortType>> factoryShort;
    private final InterpolatorFactory<FloatType, RandomAccessible<FloatType>> factoryFloat;
    private boolean extend = false;
    private int extendValue = 0;

    @Override
    public VoxelBuffer<UnsignedByteBuffer> resizeByte(VoxelBuffer<UnsignedByteBuffer> voxelsSource, VoxelBuffer<UnsignedByteBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        Img<UnsignedByteType> in = ConvertToImg.fromByte(voxelsSource, extentSource);
        Img<UnsignedByteType> out = ConvertToImg.fromByte(voxelsDestination, extentDestination);
        RealRandomAccessible interpolant = Views.interpolate(this.outOfBoundsView(in), this.factoryByte);
        VoxelsResizerImgLib2.interpolate2D(interpolant, out, extentSource);
        return voxelsDestination;
    }

    @Override
    public VoxelBuffer<UnsignedShortBuffer> resizeShort(VoxelBuffer<UnsignedShortBuffer> voxelsSource, VoxelBuffer<UnsignedShortBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        Img<UnsignedShortType> in = ConvertToImg.fromShort(voxelsSource, extentSource);
        Img<UnsignedShortType> out = ConvertToImg.fromShort(voxelsDestination, extentDestination);
        RealRandomAccessible interpolant = Views.interpolate(this.outOfBoundsView(in), this.factoryShort);
        VoxelsResizerImgLib2.interpolate2D(interpolant, out, extentSource);
        return voxelsDestination;
    }

    @Override
    public VoxelBuffer<FloatBuffer> resizeFloat(VoxelBuffer<FloatBuffer> voxelsSource, VoxelBuffer<FloatBuffer> voxelsDestination, Extent extentSource, Extent extentDestination) {
        Img<FloatType> in = ConvertToImg.fromFloat(voxelsSource, extentSource);
        Img<FloatType> out = ConvertToImg.fromFloat(voxelsDestination, extentDestination);
        RealRandomAccessible interpolant = Views.interpolate(this.outOfBoundsView(in), this.factoryFloat);
        VoxelsResizerImgLib2.interpolate2D(interpolant, out, extentSource);
        return voxelsDestination;
    }

    public void extendWith(int extendValue) {
        this.extend = true;
        this.extendValue = extendValue;
    }

    private <T extends AbstractRealType<T>> ExtendedRandomAccessibleInterval<T, Img<T>> outOfBoundsView(Img<T> imgIn) {
        if (this.extend) {
            return Views.extendValue(imgIn, (float)this.extendValue);
        }
        return Views.extendMirrorSingle(imgIn);
    }

    private static <T extends Type<T>> Img<T> interpolate2D(RealRandomAccessible<T> source, Img<T> destination, Extent extentSrc) {
        Cursor cursor = destination.localizingCursor();
        RealRandomAccess interpolatedAccess = source.realRandomAccess();
        double[] positionInterpolated = new double[2];
        double[] magnification = new double[]{destination.realMax(0) / (double)extentSrc.x(), destination.realMax(1) / (double)extentSrc.y()};
        while (cursor.hasNext()) {
            cursor.fwd();
            positionInterpolated[0] = cursor.getDoublePosition(0) / magnification[0] + -0.5;
            positionInterpolated[1] = cursor.getDoublePosition(1) / magnification[1] + -0.5;
            interpolatedAccess.setPosition(positionInterpolated);
            ((Type)cursor.get()).set((Type)interpolatedAccess.get());
        }
        return destination;
    }

    public VoxelsResizerImgLib2(InterpolatorFactory<UnsignedByteType, RandomAccessible<UnsignedByteType>> factoryByte, InterpolatorFactory<UnsignedShortType, RandomAccessible<UnsignedShortType>> factoryShort, InterpolatorFactory<FloatType, RandomAccessible<FloatType>> factoryFloat) {
        this.factoryByte = factoryByte;
        this.factoryShort = factoryShort;
        this.factoryFloat = factoryFloat;
    }
}

