/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.statistics;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.math.histogram.Histogram;

public class HistogramFactory {
    public static Histogram createFrom(VoxelBuffer<?> buffer) {
        Histogram histogram = new Histogram((int)buffer.dataType().maxValue());
        HistogramFactory.addBufferToHistogram(histogram, buffer, buffer.capacity());
        return histogram;
    }

    public static Histogram createFrom(VoxelsUntyped voxels) {
        return HistogramFactory.createFromVoxels(voxels.any());
    }

    private static Histogram createFromVoxels(Voxels<?> inputBox) {
        long minValue = inputBox.dataType().minValue();
        long maxValue = inputBox.dataType().maxValue();
        if (maxValue == -1L) {
            maxValue = inputBox.extract().voxelWithMaxIntensity();
        }
        if (maxValue > 65535L) {
            maxValue = 65535L;
        }
        minValue = minValue == -1L ? inputBox.extract().voxelWithMinIntensity() : 0L;
        Histogram histogram = new Histogram((int)minValue, (int)maxValue);
        int volumeXY = inputBox.extent().areaXY();
        inputBox.extent().iterateOverZ(z -> HistogramFactory.addBufferToHistogram(histogram, inputBox.slice(z), volumeXY));
        return histogram;
    }

    private static void addBufferToHistogram(Histogram histogram, VoxelBuffer<?> buffer, int maxOffset) {
        for (int offset = 0; offset < maxOffset; ++offset) {
            int val = buffer.getInt(offset);
            histogram.incrementValue(val);
        }
    }

    private HistogramFactory() {
    }
}

