/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.statistics;

import java.util.ArrayList;
import java.util.List;
import org.anchoranalysis.bean.shared.relation.threshold.RelationToThreshold;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.statistics.VoxelStatistics;
import org.anchoranalysis.math.histogram.Histogram;

public class VoxelStatisticsCombined
implements VoxelStatistics {
    private List<VoxelStatistics> list = new ArrayList<VoxelStatistics>();

    public void add(VoxelStatistics element) {
        this.list.add(element);
    }

    @Override
    public long size() {
        int size = 0;
        for (VoxelStatistics stats : this.list) {
            size = (int)((long)size + stats.size());
        }
        return size;
    }

    @Override
    public long sum() {
        int sum = 0;
        for (VoxelStatistics stats : this.list) {
            sum = (int)((long)sum + stats.sum());
        }
        return sum;
    }

    @Override
    public long sumOfSquares() {
        long count = 0L;
        for (VoxelStatistics stats : this.list) {
            count += stats.sumOfSquares();
        }
        return count;
    }

    @Override
    public VoxelStatistics threshold(RelationToThreshold relationToThreshold) {
        VoxelStatisticsCombined out = new VoxelStatisticsCombined();
        for (VoxelStatistics element : this.list) {
            out.add(element.threshold(relationToThreshold));
        }
        return out;
    }

    @Override
    public long countThreshold(RelationToThreshold relationToThreshold) {
        long count = 0L;
        for (VoxelStatistics element : this.list) {
            count += element.countThreshold(relationToThreshold);
        }
        return count;
    }

    @Override
    public double quantile(double quantile) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Histogram histogram() throws OperationFailedException {
        Histogram out = new Histogram(255);
        for (VoxelStatistics element : this.list) {
            out.addHistogram(element.histogram());
        }
        return out;
    }
}

