/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.statistics;

import org.anchoranalysis.bean.shared.relation.threshold.RelationToThreshold;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.voxel.statistics.VoxelStatistics;
import org.anchoranalysis.math.histogram.Histogram;

public class VoxelStatisticsFromHistogram
implements VoxelStatistics {
    private final Histogram histogram;

    @Override
    public long size() {
        return this.histogram.getTotalCount();
    }

    @Override
    public long sum() {
        return this.histogram.calculateSum();
    }

    @Override
    public long sumOfSquares() {
        return this.histogram.calculateSumSquares();
    }

    @Override
    public VoxelStatistics threshold(RelationToThreshold relationToThreshold) {
        throw new UnsupportedOperationException("The threshold operation is not currently supported");
    }

    @Override
    public long countThreshold(RelationToThreshold relationToThreshold) {
        return this.histogram.countMatching(relationToThreshold.asPredicateInt());
    }

    @Override
    public double quantile(double quantile) throws OperationFailedException {
        return this.histogram.quantile(quantile);
    }

    @Override
    public Histogram histogram() {
        return this.histogram;
    }

    public VoxelStatisticsFromHistogram(Histogram histogram) {
        this.histogram = histogram;
    }
}

