/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.thresholder;

import java.nio.FloatBuffer;
import java.util.Optional;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxelsFactory;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsObjectMaskOptional;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.thresholder.ThresholdEachVoxelByte;
import org.anchoranalysis.image.voxel.thresholder.ThresholdEachVoxelFloat;

public class VoxelsThresholder {
    public static void thresholdByte(Voxels<UnsignedByteBuffer> voxels, int level, BinaryValuesByte binaryValues) {
        try {
            VoxelsThresholder.threshold(new VoxelsUntyped(voxels), level, binaryValues, Optional.empty(), false);
        }
        catch (OperationFailedException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    public static BinaryVoxels<UnsignedByteBuffer> thresholdFloat(Voxels<FloatBuffer> voxels, float level, BinaryValuesByte binaryValues) {
        try {
            return VoxelsThresholder.threshold(new VoxelsUntyped(voxels), level, binaryValues, Optional.empty(), false);
        }
        catch (OperationFailedException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    public static BinaryVoxels<UnsignedByteBuffer> threshold(VoxelsUntyped voxels, float level, BinaryValuesByte binaryValues, Optional<ObjectMask> objectMask, boolean alwaysDuplicate) throws OperationFailedException {
        Voxels<UnsignedByteBuffer> out;
        if (voxels.getVoxelDataType().equals(UnsignedByteVoxelType.INSTANCE)) {
            out = VoxelsThresholder.voxelsAsByteOrEmpty(voxels, alwaysDuplicate);
            IterateVoxelsObjectMaskOptional.withBuffer(objectMask, voxels.asByte(), new ThresholdEachVoxelByte((int)level, out, binaryValues));
        } else if (voxels.getVoxelDataType().equals(FloatVoxelType.INSTANCE)) {
            out = VoxelsFactory.getUnsignedByte().createInitialized(voxels.extent());
            IterateVoxelsObjectMaskOptional.withTwoBuffers(objectMask, voxels.asFloat(), out, new ThresholdEachVoxelFloat(level, binaryValues));
        } else {
            throw new OperationFailedException("Unsupported voxel-data-type, only unsigned byte and float are supported");
        }
        return BinaryVoxelsFactory.reuseByte(out, binaryValues.asInt());
    }

    private static Voxels<UnsignedByteBuffer> voxelsAsByteOrEmpty(VoxelsUntyped buffer, boolean duplicate) {
        Voxels<UnsignedByteBuffer> boxOut = !duplicate && buffer.getVoxelDataType().equals(UnsignedByteVoxelType.INSTANCE) ? buffer.asByte() : VoxelsFactory.getUnsignedByte().createInitialized(buffer.any().extent());
        return boxOut;
    }

    private VoxelsThresholder() {
    }
}

