/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.binary;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;

class BinaryVoxelsInt
extends BinaryVoxels<UnsignedIntBuffer> {
    public BinaryVoxelsInt(Voxels<UnsignedIntBuffer> voxels, BinaryValuesInt binaryValues) {
        super(voxels, binaryValues);
    }

    @Override
    public boolean isOn(int x, int y, int z) {
        int offset = this.voxels().extent().offset(x, y);
        return ((UnsignedIntBuffer)this.voxels().sliceBuffer(z)).getRaw(offset) != this.binaryValues().getOff();
    }

    @Override
    public boolean isOff(int x, int y, int z) {
        return !this.isOn(x, y, z);
    }

    @Override
    public void setOn(int x, int y, int z) {
        int offset = this.voxels().extent().offset(x, y);
        ((UnsignedIntBuffer)this.voxels().sliceBuffer(z)).putRaw(offset, this.binaryValues().getOn());
    }

    @Override
    public void setOff(int x, int y, int z) {
        int offset = this.voxels().extent().offset(x, y);
        ((UnsignedIntBuffer)this.voxels().sliceBuffer(z)).putRaw(offset, this.binaryValues().getOff());
    }

    @Override
    public BinaryVoxels<UnsignedIntBuffer> duplicate() {
        return new BinaryVoxelsInt(this.voxels().duplicate(), this.binaryValues());
    }

    @Override
    protected BinaryVoxels<UnsignedIntBuffer> binaryVoxelsFor(Voxels<UnsignedIntBuffer> voxels, BinaryValuesInt binaryValues) {
        return new BinaryVoxelsInt(voxels, binaryValues);
    }
}

