/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.binary.connected;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.function.Consumer;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.connected.BufferReadWrite;
import org.anchoranalysis.image.voxel.binary.connected.MergeWithNeighbors;
import org.anchoranalysis.image.voxel.binary.connected.PointRangeWithCount;
import org.anchoranalysis.image.voxel.binary.connected.PopulateIndexProcessor;
import org.anchoranalysis.image.voxel.binary.connected.ReadWriteByte;
import org.anchoranalysis.image.voxel.binary.connected.ReadWriteInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracter;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsAll;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.jgrapht.alg.util.UnionFind;

class ConnectedComponentUnionFind {
    private final int minNumberVoxels;
    private final boolean bigNeighborhood;

    public ObjectCollection deriveConnectedByte(BinaryVoxels<UnsignedByteBuffer> voxels) {
        return this.deriveConnected(voxels, new ReadWriteByte());
    }

    public ObjectCollection deriveConnectedInt(BinaryVoxels<UnsignedIntBuffer> voxels) {
        return this.deriveConnected(voxels, new ReadWriteInt());
    }

    private <T> ObjectCollection deriveConnected(BinaryVoxels<T> voxels, BufferReadWrite<T> bufferReaderWriter) {
        LinkedList objects = new LinkedList();
        this.visitRegion(voxels, objects::add, this.minNumberVoxels, bufferReaderWriter);
        return new ObjectCollection(new ArrayList<ObjectMask>(objects));
    }

    private <T> void visitRegion(BinaryVoxels<T> visited, Consumer<ObjectMask> consumer, int minimumNumberVoxels, BufferReadWrite<T> bufferReaderWriter) {
        UnionFind unionIndex = new UnionFind(new HashSet());
        Voxels<UnsignedIntBuffer> indexBuffer = VoxelsFactory.getUnsignedInt().createInitialized(visited.extent());
        int maxBigIDAdded = ConnectedComponentUnionFind.populateIndexFromBinary(visited, new PopulateIndexProcessor<T>(visited, indexBuffer, this.createMergeWithNeighbors(indexBuffer, (UnionFind<Integer>)unionIndex), bufferReaderWriter));
        ConnectedComponentUnionFind.processIndexBuffer(maxBigIDAdded, (UnionFind<Integer>)unionIndex, indexBuffer, consumer, minimumNumberVoxels);
    }

    private MergeWithNeighbors createMergeWithNeighbors(Voxels<UnsignedIntBuffer> indexBuffer, UnionFind<Integer> unionIndex) {
        return new MergeWithNeighbors(indexBuffer, unionIndex, indexBuffer.extent().z() > 1, this.bigNeighborhood);
    }

    private static <T> int populateIndexFromBinary(BinaryVoxels<T> visited, PopulateIndexProcessor<T> process) {
        IterateVoxelsAll.withBuffer(visited.voxels(), process);
        return process.getCount() - 1;
    }

    private static Set<Integer> setFromUnionFind(int maxValue, UnionFind<Integer> unionIndex) {
        TreeSet<Integer> set = new TreeSet<Integer>();
        for (int i = 1; i <= maxValue; ++i) {
            set.add((Integer)unionIndex.find((Object)i));
        }
        return set;
    }

    private static Map<Integer, Integer> mapValuesToContiguousSet(Set<Integer> setIDs) {
        TreeMap<Integer, Integer> mapIDOrdered = new TreeMap<Integer, Integer>();
        int count = 1;
        for (Integer id : setIDs) {
            mapIDOrdered.put(id, count);
            ++count;
        }
        return mapIDOrdered;
    }

    private static PointRangeWithCount[] createBBoxArray(int size) {
        PointRangeWithCount[] boxArray = new PointRangeWithCount[size];
        for (int i = 0; i < boxArray.length; ++i) {
            boxArray[i] = new PointRangeWithCount();
        }
        return boxArray;
    }

    private static void addPointsAndAssignNewIdentifiers(Voxels<UnsignedIntBuffer> indexBuffer, UnionFind<Integer> unionIndex, Map<Integer, Integer> mapIDOrdered, PointRangeWithCount[] boxArr) {
        Point3i point = new Point3i();
        Extent extent = indexBuffer.extent();
        point.setZ(0);
        while (point.z() < extent.z()) {
            UnsignedIntBuffer bufferIndex = indexBuffer.sliceBuffer(point.z());
            int offset = 0;
            point.setY(0);
            while (point.y() < extent.y()) {
                point.setX(0);
                while (point.x() < extent.x()) {
                    int idBig = bufferIndex.getRaw(offset);
                    if (idBig != 0) {
                        Integer idSmall = mapIDOrdered.get(unionIndex.find((Object)idBig));
                        PointRangeWithCount box = boxArr[idSmall - 1];
                        box.add(point);
                        bufferIndex.putRaw(offset, idSmall);
                    }
                    ++offset;
                    point.incrementX();
                }
                point.incrementY();
            }
            point.incrementZ();
        }
    }

    private static void extractMasksInto(PointRangeWithCount[] boxArr, Map<Integer, Integer> mapIDOrdered, Voxels<UnsignedIntBuffer> indexBuffer, int minNumberVoxels, Consumer<ObjectMask> consume) {
        VoxelsExtracter<UnsignedIntBuffer> extracter = indexBuffer.extract();
        for (int smallID : mapIDOrdered.values()) {
            PointRangeWithCount boxWithCnt = boxArr[smallID - 1];
            if (boxWithCnt.getCount() < minNumberVoxels) continue;
            try {
                consume.accept(extracter.voxelsEqualTo(smallID).deriveObject(boxWithCnt.deriveBoundingBox()));
            }
            catch (OperationFailedException e) {
                throw new AnchorImpossibleSituationException();
            }
        }
    }

    private static void processIndexBuffer(int maxBigIDAdded, UnionFind<Integer> unionIndex, Voxels<UnsignedIntBuffer> indexBuffer, Consumer<ObjectMask> consumer, int minNumberVoxels) {
        Set<Integer> primaryIDs = ConnectedComponentUnionFind.setFromUnionFind(maxBigIDAdded, unionIndex);
        Map<Integer, Integer> mapIDOrdered = ConnectedComponentUnionFind.mapValuesToContiguousSet(primaryIDs);
        PointRangeWithCount[] boxArr = ConnectedComponentUnionFind.createBBoxArray(mapIDOrdered.size());
        ConnectedComponentUnionFind.addPointsAndAssignNewIdentifiers(indexBuffer, unionIndex, mapIDOrdered, boxArr);
        ConnectedComponentUnionFind.extractMasksInto(boxArr, mapIDOrdered, indexBuffer, minNumberVoxels, consumer);
    }

    @Generated
    public ConnectedComponentUnionFind(int minNumberVoxels, boolean bigNeighborhood) {
        this.minNumberVoxels = minNumberVoxels;
        this.bigNeighborhood = bigNeighborhood;
    }
}

