/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.binary.connected;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.connected.BufferReadWrite;
import org.anchoranalysis.image.voxel.binary.connected.MergeWithNeighbors;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferUnary;
import org.anchoranalysis.spatial.point.Point3i;

class PopulateIndexProcessor<T>
implements ProcessBufferUnary<T> {
    private Voxels<UnsignedIntBuffer> indexBuffer;
    private MergeWithNeighbors mergeWithNeighbors;
    private BinaryValuesInt binaryValues;
    private BinaryValuesByte binaryValyesByte;
    private final BufferReadWrite<T> bufferReaderWriter;
    private UnsignedIntBuffer bufferIndex;
    private int count = 1;

    public PopulateIndexProcessor(BinaryVoxels<T> visited, Voxels<UnsignedIntBuffer> indexBuffer, MergeWithNeighbors mergeWithNeighbors, BufferReadWrite<T> bufferReaderWriter) {
        this.indexBuffer = indexBuffer;
        this.mergeWithNeighbors = mergeWithNeighbors;
        this.bufferReaderWriter = bufferReaderWriter;
        this.binaryValues = visited.binaryValues();
        this.binaryValyesByte = this.binaryValues.asByte();
    }

    @Override
    public void notifyChangeSlice(int z) {
        this.bufferIndex = this.indexBuffer.sliceBuffer(z);
        if (z != 0) {
            this.mergeWithNeighbors.shift();
        }
    }

    @Override
    public void process(Point3i point, T buffer, int offsetSlice) {
        if (this.bufferReaderWriter.isBufferOn(buffer, offsetSlice, this.binaryValues, this.binaryValyesByte) && this.bufferIndex.getRaw(offsetSlice) == 0) {
            int neighborLabel = this.mergeWithNeighbors.minNeighborLabel(point, 0, offsetSlice);
            if (neighborLabel == -1) {
                this.bufferReaderWriter.putBufferCount(buffer, offsetSlice, this.count);
                this.bufferIndex.putRaw(offsetSlice, this.count);
                this.mergeWithNeighbors.addElement(this.count);
                ++this.count;
            } else {
                this.bufferIndex.putRaw(offsetSlice, neighborLabel);
            }
        }
    }

    public int getCount() {
        return this.count;
    }
}

