/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.buffer;

import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.buffer.DuplicateBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.PrimitiveConverter;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;

final class VoxelBufferFloat
extends VoxelBuffer<FloatBuffer> {
    private final FloatBuffer buffer;

    public VoxelBufferFloat(FloatBuffer buffer) {
        this.buffer = buffer;
    }

    @Override
    public FloatBuffer buffer() {
        return this.buffer;
    }

    @Override
    public VoxelBuffer<FloatBuffer> duplicate() {
        return new VoxelBufferFloat(DuplicateBuffer.copy(this.buffer));
    }

    @Override
    public VoxelDataType dataType() {
        return FloatVoxelType.INSTANCE;
    }

    @Override
    public int getInt(int index) {
        return (int)this.buffer.get(index);
    }

    @Override
    public void putInt(int index, int value) {
        this.buffer.put(index, value);
    }

    @Override
    public void putByte(int index, byte value) {
        this.buffer.put(index, PrimitiveConverter.unsignedByteToInt(value));
    }

    @Override
    public void copyVoxelFrom(int destinationIndex, VoxelBuffer<FloatBuffer> src, int sourceIndex) {
        this.buffer.put(destinationIndex, src.buffer().get(sourceIndex));
    }

    @Override
    public int capacity() {
        return this.buffer.capacity();
    }

    @Override
    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    @Override
    public void position(int newPosition) {
        this.buffer.position(newPosition);
    }

    @Override
    public boolean isDirect() {
        return this.buffer.isDirect();
    }

    @Override
    public ByteBuffer underlyingBytes() {
        ByteBuffer bufferByte = ByteBuffer.allocate(this.buffer.capacity() * 4);
        bufferByte.asFloatBuffer().put(this.buffer);
        return bufferByte;
    }
}

