/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.buffer;

import java.nio.ByteBuffer;
import org.anchoranalysis.image.voxel.buffer.DuplicateBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBufferUnsigned;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;

final class VoxelBufferUnsignedByte
extends VoxelBufferUnsigned<UnsignedByteBuffer> {
    public VoxelBufferUnsignedByte(UnsignedByteBuffer buffer) {
        super(buffer);
    }

    public byte get(int index) {
        return ((UnsignedByteBuffer)this.buffer()).getRaw(index);
    }

    public UnsignedByteBuffer put(int index, byte value) {
        ((UnsignedByteBuffer)this.buffer()).putRaw(index, value);
        return (UnsignedByteBuffer)this.buffer();
    }

    @Override
    public VoxelBuffer<UnsignedByteBuffer> duplicate() {
        return new VoxelBufferUnsignedByte(DuplicateBuffer.copy((UnsignedByteBuffer)this.buffer()));
    }

    @Override
    public VoxelDataType dataType() {
        return UnsignedByteVoxelType.INSTANCE;
    }

    @Override
    public int getInt(int index) {
        return ((UnsignedByteBuffer)this.buffer()).getUnsigned(index);
    }

    @Override
    public void putInt(int index, int value) {
        ((UnsignedByteBuffer)this.buffer()).putUnsigned(index, value);
    }

    @Override
    public void putByte(int index, byte value) {
        ((UnsignedByteBuffer)this.buffer()).putRaw(index, value);
    }

    @Override
    public void copyVoxelFrom(int destinationIndex, VoxelBuffer<UnsignedByteBuffer> src, int sourceIndex) {
        ((UnsignedByteBuffer)this.buffer()).putRaw(destinationIndex, src.buffer().getRaw(sourceIndex));
    }

    @Override
    public ByteBuffer underlyingBytes() {
        return ((UnsignedByteBuffer)this.buffer()).getDelegate();
    }
}

