/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.buffer;

import java.nio.ByteBuffer;
import org.anchoranalysis.image.voxel.buffer.DuplicateBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBufferUnsigned;
import org.anchoranalysis.image.voxel.buffer.primitive.PrimitiveConverter;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedShortVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;

final class VoxelBufferUnsignedShort
extends VoxelBufferUnsigned<UnsignedShortBuffer> {
    public VoxelBufferUnsignedShort(UnsignedShortBuffer buffer) {
        super(buffer);
    }

    @Override
    public VoxelBuffer<UnsignedShortBuffer> duplicate() {
        return new VoxelBufferUnsignedShort(DuplicateBuffer.copy((UnsignedShortBuffer)this.buffer()));
    }

    @Override
    public VoxelDataType dataType() {
        return UnsignedShortVoxelType.INSTANCE;
    }

    @Override
    public int getInt(int index) {
        return ((UnsignedShortBuffer)this.buffer()).getUnsigned(index);
    }

    @Override
    public void putInt(int index, int value) {
        ((UnsignedShortBuffer)this.buffer()).putUnsigned(index, value);
    }

    @Override
    public void putByte(int index, byte value) {
        ((UnsignedShortBuffer)this.buffer()).putUnsigned(index, PrimitiveConverter.unsignedByteToInt(value));
    }

    @Override
    public void copyVoxelFrom(int destinationIndex, VoxelBuffer<UnsignedShortBuffer> src, int sourceIndex) {
        ((UnsignedShortBuffer)this.buffer()).putRaw(destinationIndex, src.buffer().getRaw(sourceIndex));
    }

    @Override
    public ByteBuffer underlyingBytes() {
        ByteBuffer bufferSigned = ByteBuffer.allocate(this.capacity() * 2);
        bufferSigned.asShortBuffer().put(((UnsignedShortBuffer)this.buffer()).getDelegate());
        return bufferSigned;
    }
}

