/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.buffer.slice;

import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBufferFactory;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.slice.SliceBufferIndex;
import org.anchoranalysis.spatial.box.Extent;

public class FromInt
implements SliceBufferIndex<UnsignedIntBuffer> {
    private final VoxelBuffer<UnsignedIntBuffer>[] buffer;
    private final Extent extent;

    public static SliceBufferIndex<UnsignedIntBuffer> createInitialized(Extent extent) {
        FromInt p = new FromInt(extent);
        p.initialize();
        return p;
    }

    public static SliceBufferIndex<UnsignedIntBuffer> createUninitialized(Extent extent) {
        return new FromInt(extent);
    }

    private FromInt(Extent extent) {
        assert (extent.z() > 0);
        this.extent = extent;
        this.buffer = VoxelBufferFactory.allocateUnsignedIntArray(extent.z());
    }

    private void initialize() {
        int volumeXY = this.extent.areaXY();
        for (int z = 0; z < this.extent.z(); ++z) {
            this.buffer[z] = VoxelBufferFactory.allocateUnsignedInt(volumeXY);
        }
    }

    @Override
    public void replaceSlice(int z, VoxelBuffer<UnsignedIntBuffer> sliceToAssign) {
        sliceToAssign.buffer().clear();
        this.buffer[z] = sliceToAssign;
    }

    @Override
    public VoxelBuffer<UnsignedIntBuffer> slice(int z) {
        VoxelBuffer<UnsignedIntBuffer> buf = this.buffer[z];
        buf.buffer().clear();
        return buf;
    }

    @Override
    public Extent extent() {
        return this.extent;
    }
}

