/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.datatype;

import java.util.Optional;
import java.util.stream.Stream;
import lombok.Generated;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.image.voxel.datatype.FloatVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;

public class FindCommonVoxelType {
    public static Optional<VoxelDataType> commonType(Stream<VoxelDataType> stream) {
        return stream.reduce(FindCommonVoxelType::commonType);
    }

    public static VoxelDataType commonType(VoxelDataType first, VoxelDataType second) {
        if (!first.isInteger() || !second.isInteger()) {
            return FloatVoxelType.INSTANCE;
        }
        if (first.bitDepth() > second.bitDepth()) {
            return first;
        }
        if (first.bitDepth() < second.bitDepth()) {
            return second;
        }
        if (first.isUnsigned() == second.isUnsigned()) {
            return first;
        }
        throw new AnchorImpossibleSituationException();
    }

    @Generated
    private FindCommonVoxelType() {
    }
}

