/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.datatype;

import lombok.Generated;
import org.apache.commons.lang.builder.HashCodeBuilder;

public abstract class VoxelDataType {
    public static final long VALUE_NOT_COMPATIBLE = -1L;
    private int bitDepth;
    private String typeIdentifier;
    private long maxValue;
    private long minValue;

    public boolean equals(Object obj) {
        if (!(obj instanceof VoxelDataType)) {
            return false;
        }
        VoxelDataType otherCasted = (VoxelDataType)obj;
        if (this.isInteger() != otherCasted.isInteger()) {
            return false;
        }
        if (this.isUnsigned() != otherCasted.isUnsigned()) {
            return false;
        }
        return this.bitDepth() == otherCasted.bitDepth();
    }

    public int hashCode() {
        return new HashCodeBuilder().append(this.isInteger()).append(this.isUnsigned()).append(this.bitDepth()).toHashCode();
    }

    public abstract boolean isInteger();

    public abstract boolean isUnsigned();

    public final String toString() {
        return this.typeIdentifier;
    }

    public int numberBytes() {
        return this.bitDepth / 8;
    }

    @Generated
    public VoxelDataType(int bitDepth, String typeIdentifier, long maxValue, long minValue) {
        this.bitDepth = bitDepth;
        this.typeIdentifier = typeIdentifier;
        this.maxValue = maxValue;
        this.minValue = minValue;
    }

    @Generated
    public int bitDepth() {
        return this.bitDepth;
    }

    @Generated
    public long maxValue() {
        return this.maxValue;
    }

    @Generated
    public long minValue() {
        return this.minValue;
    }
}

