/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.extracter;

import lombok.Generated;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracter;
import org.anchoranalysis.image.voxel.extracter.predicate.PredicateAtCorner;
import org.anchoranalysis.image.voxel.extracter.predicate.VoxelsPredicate;
import org.anchoranalysis.image.voxel.iterator.MinMaxRange;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class AtCorner<T>
implements VoxelsExtracter<T> {
    private ReadableTuple3i corner;
    private VoxelsExtracter<T> delegate;

    @Override
    public int voxel(ReadableTuple3i point) {
        return this.delegate.voxel(this.shiftBack(point));
    }

    @Override
    public Voxels<T> slice(int sliceIndex) {
        return this.delegate.slice(sliceIndex - this.corner.z());
    }

    @Override
    public Voxels<T> region(BoundingBox box, boolean reuseIfPossible) {
        return this.delegate.region(this.shiftBack(box), reuseIfPossible);
    }

    @Override
    public void boxCopyTo(BoundingBox from, Voxels<T> voxelsDestination, BoundingBox destinationBox) {
        this.delegate.boxCopyTo(this.shiftBack(from), voxelsDestination, destinationBox);
    }

    @Override
    public Voxels<T> resizedXY(int sizeX, int sizeY, VoxelsResizer resizer) {
        return this.delegate.resizedXY(sizeX, sizeY, resizer);
    }

    @Override
    public Voxels<T> projectMax() {
        return this.delegate.projectMax();
    }

    @Override
    public Voxels<T> projectMean() {
        return this.delegate.projectMean();
    }

    @Override
    public VoxelsPredicate voxelsEqualTo(int equalToValue) {
        return new PredicateAtCorner(this.corner, this.delegate.voxelsEqualTo(equalToValue));
    }

    @Override
    public VoxelsPredicate voxelsGreaterThan(int threshold) {
        return new PredicateAtCorner(this.corner, this.delegate.voxelsGreaterThan(threshold));
    }

    @Override
    public long voxelWithMaxIntensity() {
        return this.delegate.voxelWithMaxIntensity();
    }

    @Override
    public long voxelWithMinIntensity() {
        return this.delegate.voxelWithMinIntensity();
    }

    @Override
    public MinMaxRange voxelsWithMinMaxIntensity() {
        return this.delegate.voxelsWithMinMaxIntensity();
    }

    @Override
    public void objectCopyTo(ObjectMask from, Voxels<T> voxelsDestination, BoundingBox destinationBox) {
        this.delegate.objectCopyTo(this.shiftBack(from), voxelsDestination, destinationBox);
    }

    private ReadableTuple3i shiftBack(ReadableTuple3i point) {
        return Point3i.immutableSubtract((ReadableTuple3i)point, (ReadableTuple3i)this.corner);
    }

    private BoundingBox shiftBack(BoundingBox box) {
        return box.shiftBackBy(this.corner);
    }

    private ObjectMask shiftBack(ObjectMask object) {
        return object.shiftBackBy(this.corner);
    }

    @Generated
    public AtCorner(ReadableTuple3i corner, VoxelsExtracter<T> delegate) {
        this.corner = corner;
        this.delegate = delegate;
    }
}

