/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.extracter;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracterBase;
import org.anchoranalysis.image.voxel.iterator.MinMaxRange;
import org.anchoranalysis.image.voxel.projection.MeanIntensityProjection;
import org.anchoranalysis.image.voxel.projection.extrema.MaxIntensityProjection;
import org.anchoranalysis.spatial.box.Extent;

class FloatImplementation
extends VoxelsExtracterBase<FloatBuffer> {
    public FloatImplementation(Voxels<FloatBuffer> voxels) {
        super(voxels);
    }

    @Override
    public void copySingleVoxelTo(FloatBuffer sourceBuffer, int sourceIndex, FloatBuffer destinationBuffer, int destinationIndex) {
        destinationBuffer.put(destinationIndex, sourceBuffer.get(sourceIndex));
    }

    @Override
    public long voxelWithMaxIntensity() {
        float max = Float.MIN_VALUE;
        Extent extent = this.voxels.extent();
        for (int z = 0; z < extent.z(); ++z) {
            FloatBuffer pixels = (FloatBuffer)this.voxels.sliceBuffer(z);
            while (pixels.hasRemaining()) {
                float value = pixels.get();
                if (!(value > max)) continue;
                max = value;
            }
        }
        return (long)Math.ceil(max);
    }

    @Override
    public long voxelWithMinIntensity() {
        float min = Float.MAX_VALUE;
        Extent extent = this.voxels.extent();
        for (int z = 0; z < extent.z(); ++z) {
            FloatBuffer pixels = (FloatBuffer)this.voxels.sliceBuffer(z);
            while (pixels.hasRemaining()) {
                float value = pixels.get();
                if (!(value < min)) continue;
                min = value;
            }
        }
        return (long)Math.floor(min);
    }

    @Override
    public MinMaxRange voxelsWithMinMaxIntensity() {
        float min = Float.MAX_VALUE;
        float max = Float.MIN_VALUE;
        Extent extent = this.voxels.extent();
        for (int z = 0; z < extent.z(); ++z) {
            FloatBuffer pixels = (FloatBuffer)this.voxels.sliceBuffer(z);
            while (pixels.hasRemaining()) {
                float value = pixels.get();
                if (value < min) {
                    min = value;
                }
                if (!(value > max)) continue;
                max = value;
            }
        }
        return new MinMaxRange((long)Math.floor(min), (long)Math.ceil(max));
    }

    @Override
    protected int voxelAtBufferIndex(FloatBuffer buffer, int index) {
        return (int)buffer.get(index);
    }

    @Override
    protected boolean bufferValueGreaterThan(FloatBuffer buffer, int threshold) {
        return buffer.get() > (float)threshold;
    }

    @Override
    protected boolean bufferValueEqualTo(FloatBuffer buffer, int value) {
        return buffer.get() == (float)value;
    }

    @Override
    protected ProjectableBuffer<FloatBuffer> createMaxIntensityBuffer(Extent extent) {
        return new MaxIntensityProjection().createFloat(extent);
    }

    @Override
    protected ProjectableBuffer<FloatBuffer> createMeanIntensityBuffer(Extent extent) {
        return new MeanIntensityProjection().createFloat(extent);
    }
}

