/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.extracter;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.extracter.VoxelsExtracterBase;
import org.anchoranalysis.image.voxel.iterator.MinMaxRange;
import org.anchoranalysis.image.voxel.projection.MeanIntensityProjection;
import org.anchoranalysis.image.voxel.projection.extrema.MaxIntensityProjection;
import org.anchoranalysis.spatial.box.Extent;

class UnsignedIntImplementation
extends VoxelsExtracterBase<UnsignedIntBuffer> {
    public UnsignedIntImplementation(Voxels<UnsignedIntBuffer> voxels) {
        super(voxels);
    }

    @Override
    public long voxelWithMaxIntensity() {
        long max = Long.MIN_VALUE;
        Extent extent = this.voxels.extent();
        for (int z = 0; z < extent.z(); ++z) {
            UnsignedIntBuffer pixels = (UnsignedIntBuffer)this.voxels.sliceBuffer(z);
            while (pixels.hasRemaining()) {
                long val = pixels.getUnsigned();
                if (val <= max) continue;
                max = val;
            }
        }
        return max;
    }

    @Override
    public long voxelWithMinIntensity() {
        long min = Long.MAX_VALUE;
        Extent extent = this.voxels.extent();
        for (int z = 0; z < extent.z(); ++z) {
            UnsignedIntBuffer pixels = (UnsignedIntBuffer)this.voxels.sliceBuffer(z);
            while (pixels.hasRemaining()) {
                long val = pixels.getUnsigned();
                if (val >= min) continue;
                min = val;
            }
        }
        return min;
    }

    @Override
    public MinMaxRange voxelsWithMinMaxIntensity() {
        long min = Long.MAX_VALUE;
        long max = Long.MIN_VALUE;
        Extent extent = this.voxels.extent();
        for (int z = 0; z < extent.z(); ++z) {
            UnsignedIntBuffer pixels = (UnsignedIntBuffer)this.voxels.sliceBuffer(z);
            while (pixels.hasRemaining()) {
                long val = pixels.getUnsigned();
                if (val < min) {
                    min = val;
                }
                if (val <= max) continue;
                max = val;
            }
        }
        return new MinMaxRange(min, max);
    }

    @Override
    public void copySingleVoxelTo(UnsignedIntBuffer sourceBuffer, int sourceIndex, UnsignedIntBuffer destinationBuffer, int destinationIndex) {
        destinationBuffer.putRaw(destinationIndex, sourceBuffer.getRaw(sourceIndex));
    }

    @Override
    protected int voxelAtBufferIndex(UnsignedIntBuffer buffer, int index) {
        return (int)buffer.getUnsigned(index);
    }

    @Override
    protected boolean bufferValueGreaterThan(UnsignedIntBuffer buffer, int threshold) {
        return buffer.getRaw() > threshold;
    }

    @Override
    protected boolean bufferValueEqualTo(UnsignedIntBuffer buffer, int value) {
        return buffer.getRaw() == value;
    }

    @Override
    protected ProjectableBuffer<UnsignedIntBuffer> createMaxIntensityBuffer(Extent extent) {
        return new MaxIntensityProjection().createUnsignedInt(extent);
    }

    @Override
    protected ProjectableBuffer<UnsignedIntBuffer> createMeanIntensityBuffer(Extent extent) {
        return new MeanIntensityProjection().createUnsignedInt(extent);
    }
}

