/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.kernel;

import lombok.Generated;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.kernel.KernelApplicationParameters;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;

public final class KernelPointCursor {
    private int index;
    private Point3i point;
    private final BinaryValuesByte binaryValues;
    private final KernelApplicationParameters parameters;
    private final Extent extent;
    private final int xExtent;
    private final int yExtent;
    private final int xExtentTwice;

    public KernelPointCursor(int index, Point3i point, Extent extent, BinaryValuesByte binaryValues, KernelApplicationParameters parameters) {
        this.index = index;
        this.point = point;
        this.extent = extent;
        this.xExtent = extent.x();
        this.yExtent = extent.y();
        this.xExtentTwice = this.xExtent * 2;
        this.binaryValues = binaryValues;
        this.parameters = parameters;
    }

    public void incrementX() {
        this.point.incrementX();
        ++this.index;
    }

    public void incrementXTwice() {
        this.point.incrementX(2);
        this.index += 2;
    }

    public void decrementX() {
        this.point.decrementX();
        --this.index;
    }

    public void incrementY() {
        this.point.incrementY();
        this.index += this.xExtent;
    }

    public void incrementYTwice() {
        this.point.incrementY(2);
        this.index += this.xExtentTwice;
    }

    public void decrementY() {
        this.point.decrementY();
        this.index -= this.xExtent;
    }

    public void decrementYTwice() {
        this.point.decrementY(2);
        this.index -= this.xExtentTwice;
    }

    public void incrementZ() {
        this.point.incrementZ();
    }

    public void incrementZTwice() {
        this.point.incrementZ(2);
    }

    public void decrementZ() {
        this.point.decrementZ();
    }

    public void incrementIndexOnly() {
        ++this.index;
    }

    public boolean isUseZ() {
        return this.parameters.isUseZ();
    }

    public boolean nonNegativeX() {
        return this.point.x() >= 0;
    }

    public boolean nonNegativeY() {
        return this.point.y() >= 0;
    }

    public boolean lessThanMaxX() {
        return this.point.x() < this.xExtent;
    }

    public boolean lessThanMaxY() {
        return this.point.y() < this.yExtent;
    }

    public boolean isBufferOn(UnsignedByteBuffer buffer) {
        return this.binaryValues.isOn(buffer.getRaw(this.index));
    }

    public boolean isBufferOff(UnsignedByteBuffer buffer) {
        return this.binaryValues.isOff(buffer.getRaw(this.index));
    }

    public boolean isOutsideOn() {
        return this.parameters.isOutsideOn();
    }

    public boolean isOutsideOffUnignored() {
        return this.parameters.isOutsideOffUnignored();
    }

    @Generated
    public int getIndex() {
        return this.index;
    }

    @Generated
    public void setIndex(int index) {
        this.index = index;
    }

    @Generated
    public Point3i getPoint() {
        return this.point;
    }

    @Generated
    public Extent getExtent() {
        return this.extent;
    }
}

