/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.kernel.morphological;

import java.util.function.Supplier;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.neighbor.kernel.WalkPredicate;
import org.anchoranalysis.image.voxel.kernel.BinaryKernel;
import org.anchoranalysis.image.voxel.kernel.KernelPointCursor;
import org.anchoranalysis.image.voxel.kernel.LocalSlices;

public abstract class BinaryKernelMorphological
extends BinaryKernel {
    private final boolean bigNeighborhood;
    private final boolean unqualifiedOutcome;
    private final boolean qualifiedOutcome;
    private final boolean failedFirstCheckOutcome;
    private LocalSlices slices;

    protected BinaryKernelMorphological(boolean bigNeighborhood, boolean unqualifiedOutcome, boolean failedFirstCheckOutcome) {
        super(3);
        this.unqualifiedOutcome = unqualifiedOutcome;
        this.qualifiedOutcome = !unqualifiedOutcome;
        this.bigNeighborhood = bigNeighborhood;
        this.failedFirstCheckOutcome = failedFirstCheckOutcome;
    }

    @Override
    public void notifyBuffer(LocalSlices slices, int sliceIndex) {
        this.slices = slices;
    }

    @Override
    public boolean calculateAt(KernelPointCursor point) {
        UnsignedByteBuffer buffer = this.slices.getLocal(0).get();
        if (!this.firstCheck(point, buffer)) {
            return this.failedFirstCheckOutcome;
        }
        WalkPredicate walker = new WalkPredicate(point, this::doesNeighborQualify, this.bigNeighborhood);
        if (walker.walk(buffer, this.slices)) {
            return this.qualifiedOutcome;
        }
        return this.unqualifiedOutcome;
    }

    protected abstract boolean firstCheck(KernelPointCursor var1, UnsignedByteBuffer var2);

    protected abstract boolean doesNeighborQualify(boolean var1, KernelPointCursor var2, Supplier<UnsignedByteBuffer> var3, int var4);
}

