/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.object;

import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.PointRange;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class DeriveObjectFromPoints {
    private PointRange range = new PointRange();
    private List<Point3i> points = new LinkedList<Point3i>();

    public void add(ReadableTuple3i point) {
        this.range.add(point);
        this.points.add(new Point3i(point));
    }

    public Optional<ObjectMask> deriveObject() {
        if (!this.range.isEmpty()) {
            ObjectMask object = new ObjectMask(this.range.toBoundingBoxNoCheck());
            for (Point3i point : this.points) {
                object.assignOn().toVoxel(point);
            }
            return Optional.of(object);
        }
        return Optional.empty();
    }
}

