/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.object;

import com.google.common.base.Functions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.anchoranalysis.core.graph.GraphWithoutPayload;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;
import org.anchoranalysis.spatial.rtree.BoundingBoxRTree;

public class IntersectingObjects<T> {
    private BoundingBoxRTree<T> tree;
    private final Function<T, ObjectMask> extractObject;

    public static IntersectingObjects<ObjectMask> create(ObjectCollection objects) {
        return new IntersectingObjects<ObjectMask>((Collection<ObjectMask>)objects.asList(), (Function<ObjectMask, ObjectMask>)Functions.identity());
    }

    public IntersectingObjects(Collection<T> elements, Function<T, ObjectMask> extractObject) {
        this.extractObject = extractObject;
        this.tree = new BoundingBoxRTree(elements.size());
        elements.stream().forEach(element -> this.tree.add(this.boxFor(element), element));
    }

    public Set<T> contains(Point3i point) {
        return this.tree.containsStream((ReadableTuple3i)point).filter(object -> this.extractObject.apply(object).contains(point)).collect(Collectors.toSet());
    }

    public Set<T> intersectsWith(ObjectMask object) {
        return this.intersectsWithStream(object).collect(Collectors.toSet());
    }

    public Stream<T> intersectsWithStream(ObjectMask object) {
        return this.tree.intersectsWithStream(object.boundingBox()).filter(element -> this.extractObject.apply(element).hasIntersectingVoxels(object));
    }

    public Set<T> intersectsWith(BoundingBox box) {
        return this.tree.intersectsWith(box);
    }

    public void remove(T element) {
        this.tree.remove(this.boxFor(element), element);
    }

    public Set<Set<T>> spatiallySeparate() {
        Set unprocessed = this.tree.asSet();
        HashSet<Set<T>> out = new HashSet<Set<T>>();
        while (!unprocessed.isEmpty()) {
            Object current = unprocessed.iterator().next();
            HashSet spatiallyConnected = new HashSet();
            this.addSpatiallyConnected(spatiallyConnected, current, unprocessed);
            out.add(spatiallyConnected);
        }
        return out;
    }

    public GraphWithoutPayload<T> asGraph() {
        GraphWithoutPayload graph = new GraphWithoutPayload(true);
        for (Object element : this.tree.asSet()) {
            graph.addVertex(element);
            Iterator intersecting = this.intersectsWithStream(this.extractObject.apply(element)).iterator();
            while (intersecting.hasNext()) {
                Object other = intersecting.next();
                if (element.equals(other) || graph.containsEdge(other, element)) continue;
                graph.addEdge(element, other);
            }
        }
        return graph;
    }

    public int size() {
        return this.tree.size();
    }

    private void addSpatiallyConnected(Set<T> addTo, T source, Set<T> unprocessed) {
        unprocessed.remove(source);
        addTo.add(source);
        List queue = this.tree.intersectsWith(this.boxFor(source)).stream().collect(Collectors.toCollection(ArrayList::new));
        while (!queue.isEmpty()) {
            Object current = queue.remove(0);
            if (!unprocessed.contains(current)) continue;
            unprocessed.remove(current);
            addTo.add(current);
            queue.addAll(this.tree.intersectsWith(this.boxFor(current)));
        }
    }

    private BoundingBox boxFor(T element) {
        return this.extractObject.apply(element).boundingBox();
    }
}

