/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.object;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesInt;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.object.ObjectMaskStream;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class ObjectCollection
implements Iterable<ObjectMask> {
    private final ArrayList<ObjectMask> delegate;

    public ObjectCollection(ArrayList<ObjectMask> objects) {
        this.delegate = objects;
    }

    public ObjectCollection(Stream<ObjectMask> stream) {
        this.delegate = stream.collect(Collectors.toCollection(ArrayList::new));
    }

    public ObjectCollection shiftBy(ReadableTuple3i shiftBy) {
        return this.stream().mapBoundingBoxPreserveExtent(box -> box.shiftBy(shiftBy));
    }

    public boolean equals(Object other) {
        return this.delegate.equals(other);
    }

    public boolean equalsDeep(ObjectCollection other) {
        if (this.size() != other.size()) {
            return false;
        }
        for (int i = 0; i < this.size(); ++i) {
            if (this.get(i).equalsDeep(other.get(i))) continue;
            return false;
        }
        return true;
    }

    public ObjectMask get(int index) {
        return this.delegate.get(index);
    }

    public int hashCode() {
        return this.delegate.hashCode();
    }

    public boolean isEmpty() {
        return this.delegate.isEmpty();
    }

    @Override
    public Iterator<ObjectMask> iterator() {
        return this.delegate.iterator();
    }

    public int size() {
        return this.delegate.size();
    }

    public String toString(boolean newlines, boolean includeIndices) {
        String sep = newlines ? "\n" : " ";
        StringBuilder builder = new StringBuilder();
        builder.append("( ");
        for (int index = 0; index < this.delegate.size(); ++index) {
            builder.append(ObjectCollection.objectToString(this.delegate.get(index), index, includeIndices));
            builder.append(sep);
        }
        builder.append(")");
        return builder.toString();
    }

    public String toString() {
        return this.toString(false, false);
    }

    public BinaryValuesByte getFirstBinaryValuesByte() {
        return this.get(0).binaryValuesByte();
    }

    public BinaryValuesInt getFirstBinaryValues() {
        return this.get(0).binaryValues();
    }

    public ObjectCollection duplicate() {
        return this.stream().map(ObjectMask::duplicate);
    }

    public ObjectCollection duplicateShallow() {
        return new ObjectCollection(this.streamStandardJava());
    }

    public ObjectCollection createSubset(Collection<Integer> indices) {
        return new ObjectCollection(this.streamIndices(indices));
    }

    public List<ObjectMask> asList() {
        return this.delegate;
    }

    public ObjectMaskStream stream() {
        return new ObjectMaskStream(this);
    }

    public Stream<ObjectMask> streamStandardJava() {
        return this.delegate.stream();
    }

    public Stream<ObjectMask> streamIndices(Collection<Integer> indices) {
        return indices.stream().map(this::get);
    }

    private static String objectToString(ObjectMask object, int index, boolean includeIndex) {
        String cog = object.centerOfGravity().toString();
        int numberVoxels = object.numberVoxelsOn();
        if (includeIndex) {
            return String.format("%d %s(%s)", index, cog, numberVoxels);
        }
        return String.format("%s(%s)", cog, numberVoxels);
    }
}

