/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.convert.VoxelsConverterMulti;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;
import org.anchoranalysis.spatial.box.Extent;

public abstract class CountedProjectableBuffer<T>
implements ProjectableBuffer<T> {
    private static final VoxelsConverterMulti CONVERTER = new VoxelsConverterMulti();
    private final VoxelsFactoryTypeBound<T> flatType;
    protected final Voxels<FloatBuffer> voxelsSum;
    private int count = 0;

    protected CountedProjectableBuffer(VoxelsFactoryTypeBound<T> flatType, Extent extent) {
        this.voxelsSum = VoxelsFactory.getFloat().createInitialized(extent);
        this.flatType = flatType;
    }

    @Override
    public void addVoxelBuffer(VoxelBuffer<T> voxelBuffer) {
        this.addVoxelBufferInternal(voxelBuffer, 0);
        ++this.count;
    }

    @Override
    public void addVoxels(Voxels<T> voxels) {
        for (int z = 0; z < voxels.extent().z(); ++z) {
            this.addVoxelBufferInternal(voxels.slice(z), z);
        }
        ++this.count;
    }

    protected abstract void addVoxelBufferInternal(VoxelBuffer<T> var1, int var2);

    protected Voxels<T> flattenFrom(Voxels<FloatBuffer> voxels) {
        return CONVERTER.convert(new VoxelsUntyped(voxels), this.flatType);
    }

    protected void divideVoxelsByCount(Voxels<FloatBuffer> voxels) {
        voxels.arithmetic().divideBy(this.count);
    }
}

