/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;
import org.anchoranalysis.image.voxel.projection.CountedProjectableBuffer;
import org.anchoranalysis.spatial.box.Extent;

class StandardDeviationIntensityBuffer<T>
extends CountedProjectableBuffer<T> {
    private Voxels<FloatBuffer> voxelsSumSquared;

    public StandardDeviationIntensityBuffer(VoxelsFactoryTypeBound<T> flatType, Extent extent) {
        super(flatType, extent);
        this.voxelsSumSquared = VoxelsFactory.getFloat().createInitialized(extent);
    }

    @Override
    public Voxels<T> completeProjection() {
        this.divideVoxelsByCount(this.voxelsSum);
        this.divideVoxelsByCount(this.voxelsSumSquared);
        StandardDeviationIntensityBuffer.squareEachVoxel(this.voxelsSum);
        StandardDeviationIntensityBuffer.subtractSquareRoot(this.voxelsSumSquared, this.voxelsSum);
        return this.flattenFrom(this.voxelsSumSquared);
    }

    @Override
    protected void addVoxelBufferInternal(VoxelBuffer<T> voxelBuffer, int z) {
        FloatBuffer sumBuffer = (FloatBuffer)this.voxelsSum.sliceBuffer(z);
        FloatBuffer sumSquaredBuffer = this.voxelsSumSquared.sliceBuffer(z);
        this.voxelsSum.extent().iterateOverXYOffset(offset -> this.incrementSumBuffer(offset, voxelBuffer.getInt(offset), sumBuffer, sumSquaredBuffer));
    }

    private void incrementSumBuffer(int index, int toAdd, FloatBuffer sumBuffer, FloatBuffer sumSquaredBuffer) {
        StandardDeviationIntensityBuffer.addToPosition(sumBuffer, index, toAdd);
        StandardDeviationIntensityBuffer.addToPosition(sumSquaredBuffer, index, toAdd * toAdd);
    }

    private static void addToPosition(FloatBuffer buffer, int index, int toAdd) {
        buffer.put(index, buffer.get(index) + (float)toAdd);
    }

    private static void squareEachVoxel(Voxels<FloatBuffer> voxelsBuffer) {
        for (int z = 0; z < voxelsBuffer.extent().z(); ++z) {
            FloatBuffer buffer = voxelsBuffer.sliceBuffer(z);
            buffer.rewind();
            while (buffer.hasRemaining()) {
                float value = buffer.get();
                buffer.position(buffer.position() - 1);
                buffer.put(value * value);
            }
        }
    }

    private static void subtractSquareRoot(Voxels<FloatBuffer> voxelsBufferBigger, Voxels<FloatBuffer> voxelsBufferSmaller) {
        for (int z = 0; z < voxelsBufferBigger.extent().z(); ++z) {
            FloatBuffer bufferBigger = voxelsBufferBigger.sliceBuffer(z);
            FloatBuffer bufferSmaller = voxelsBufferSmaller.sliceBuffer(z);
            bufferBigger.rewind();
            bufferSmaller.rewind();
            while (bufferBigger.hasRemaining()) {
                float bigger = bufferBigger.get();
                float smaller = bufferSmaller.get();
                float valueToAssign = (float)Math.sqrt(bigger - smaller);
                bufferBigger.position(bufferBigger.position() - 1);
                bufferBigger.put(valueToAssign);
            }
        }
    }
}

