/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection.extrema;

import java.nio.FloatBuffer;
import lombok.Generated;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedIntBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.projection.Projection;
import org.anchoranalysis.image.voxel.projection.extrema.FloatImplementation;
import org.anchoranalysis.image.voxel.projection.extrema.UnsignedByteImplementation;
import org.anchoranalysis.image.voxel.projection.extrema.UnsignedIntImplementation;
import org.anchoranalysis.image.voxel.projection.extrema.UnsignedShortImplementation;
import org.anchoranalysis.spatial.box.Extent;

public abstract class ComparisonProjection
extends Projection {
    private final IntComparer intComparer;
    private final LongComparer longComparer;
    private final FloatComparer floatComparer;

    @Override
    public ProjectableBuffer<UnsignedByteBuffer> createUnsignedByte(Extent extent) {
        return new UnsignedByteImplementation(extent, this.intComparer::compare);
    }

    @Override
    public ProjectableBuffer<UnsignedShortBuffer> createUnsignedShort(Extent extent) {
        return new UnsignedShortImplementation(extent, this.intComparer::compare);
    }

    @Override
    public ProjectableBuffer<UnsignedIntBuffer> createUnsignedInt(Extent extent) {
        return new UnsignedIntImplementation(extent, this.longComparer::compare);
    }

    @Override
    public ProjectableBuffer<FloatBuffer> createFloat(Extent extent) {
        return new FloatImplementation(extent, this.floatComparer::compare);
    }

    @Generated
    protected ComparisonProjection(IntComparer intComparer, LongComparer longComparer, FloatComparer floatComparer) {
        this.intComparer = intComparer;
        this.longComparer = longComparer;
        this.floatComparer = floatComparer;
    }

    @FunctionalInterface
    protected static interface IntComparer {
        public boolean compare(int var1, int var2);
    }

    @FunctionalInterface
    protected static interface LongComparer {
        public boolean compare(long var1, long var3);
    }

    @FunctionalInterface
    protected static interface FloatComparer {
        public boolean compare(float var1, float var2);
    }
}

