/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.projection.extrema;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.ProjectableBuffer;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactoryTypeBound;
import org.anchoranalysis.spatial.box.Extent;

abstract class MaybeReplaceBufferBase<T>
implements ProjectableBuffer<T> {
    private Voxels<T> projection;
    private final VoxelsFactoryTypeBound<T> factory;
    private final Extent extent;

    protected MaybeReplaceBufferBase(Extent extent, VoxelsFactoryTypeBound<T> factory) {
        this.factory = factory;
        this.extent = extent;
    }

    @Override
    public void addVoxels(Voxels<T> voxels) {
        if (this.projection == null) {
            this.projection = voxels.duplicate();
        } else {
            for (int z = 0; z < voxels.extent().z(); ++z) {
                this.addVoxelBufferInternal(voxels.slice(z), z);
            }
        }
    }

    @Override
    public void addVoxelBuffer(VoxelBuffer<T> voxels) {
        if (this.projection == null) {
            this.projection = this.factory.createInitialized(this.extent);
            VoxelBuffer<T> projectionBuffer = this.projection.slice(0);
            T buffer = voxels.buffer();
            while (projectionBuffer.hasRemaining()) {
                this.assignCurrentBufferPosition(buffer, projectionBuffer.buffer());
            }
        } else {
            this.addVoxelBufferInternal(voxels, 0);
        }
    }

    @Override
    public Voxels<T> completeProjection() {
        return this.projection;
    }

    protected abstract void maybeReplaceCurrentBufferPosition(T var1, T var2);

    protected abstract void assignCurrentBufferPosition(T var1, T var2);

    private void addVoxelBufferInternal(VoxelBuffer<T> voxels, int z) {
        T buffer = voxels.buffer();
        VoxelBuffer<T> projectionBuffer = this.projection.slice(z);
        while (projectionBuffer.hasRemaining()) {
            this.maybeReplaceCurrentBufferPosition(buffer, projectionBuffer.buffer());
        }
    }
}

