/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.resizer;

import com.google.common.base.Preconditions;
import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.VoxelBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedShortBuffer;
import org.anchoranalysis.image.voxel.resizer.ResizeHelper;
import org.anchoranalysis.image.voxel.resizer.TransferViaSpecificType;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizerFactory;
import org.anchoranalysis.spatial.box.Extent;

public abstract class VoxelsResizer {
    public void resize(VoxelsUntyped source, VoxelsUntyped destination) {
        Extent extentSource = source.any().extent();
        Extent extentTarget = destination.any().extent();
        Preconditions.checkArgument((extentSource.z() == extentTarget.z() ? 1 : 0) != 0);
        TransferViaSpecificType<?> transfer = ResizeHelper.createTransfer(source, destination);
        for (int z = 0; z < extentSource.z(); ++z) {
            transfer.assignSlice(z);
            if (extentSource.x() == extentTarget.x() && extentSource.y() == extentTarget.y()) {
                transfer.transferCopyTo(z);
                continue;
            }
            if (extentSource.x() != 1 && extentSource.y() != 1) {
                transfer.transferTo(z, this);
                continue;
            }
            transfer.transferTo(z, VoxelsResizerFactory.getInstance().noInterpolation());
        }
        Preconditions.checkArgument((destination.slice(0).capacity() == extentTarget.areaXY() ? 1 : 0) != 0);
    }

    public abstract boolean canValueRangeChange();

    protected abstract VoxelBuffer<UnsignedByteBuffer> resizeByte(VoxelBuffer<UnsignedByteBuffer> var1, VoxelBuffer<UnsignedByteBuffer> var2, Extent var3, Extent var4);

    protected abstract VoxelBuffer<UnsignedShortBuffer> resizeShort(VoxelBuffer<UnsignedShortBuffer> var1, VoxelBuffer<UnsignedShortBuffer> var2, Extent var3, Extent var4);

    protected abstract VoxelBuffer<FloatBuffer> resizeFloat(VoxelBuffer<FloatBuffer> var1, VoxelBuffer<FloatBuffer> var2, Extent var3, Extent var4);
}

