/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.thresholder;

import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferUnary;
import org.anchoranalysis.spatial.point.Point3i;

final class ThresholdEachVoxelByte
implements ProcessBufferUnary<UnsignedByteBuffer> {
    private final int level;
    private final Voxels<UnsignedByteBuffer> voxelsOut;
    private final byte byteOn;
    private final byte byteOff;
    private UnsignedByteBuffer bufferOut;

    public ThresholdEachVoxelByte(int level, Voxels<UnsignedByteBuffer> voxelsOut, BinaryValuesByte bvOut) {
        this.level = level;
        this.voxelsOut = voxelsOut;
        this.byteOn = bvOut.getOn();
        this.byteOff = bvOut.getOff();
    }

    @Override
    public void notifyChangeSlice(int z) {
        this.bufferOut = this.voxelsOut.sliceBuffer(z);
    }

    @Override
    public void process(Point3i point, UnsignedByteBuffer buffer, int offset) {
        int value = buffer.getUnsigned(offset);
        this.bufferOut.putRaw(offset, value >= this.level ? this.byteOn : this.byteOff);
    }
}

