/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.voxel.thresholder;

import java.nio.FloatBuffer;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.process.buffer.ProcessBufferBinary;
import org.anchoranalysis.spatial.point.Point3i;

final class ThresholdEachVoxelFloat
implements ProcessBufferBinary<FloatBuffer, UnsignedByteBuffer> {
    private final float level;
    private final byte byteOn;
    private final byte byteOff;

    public ThresholdEachVoxelFloat(float level, BinaryValuesByte bvOut) {
        this.level = level;
        this.byteOn = bvOut.getOn();
        this.byteOff = bvOut.getOff();
    }

    @Override
    public void process(Point3i point, FloatBuffer buffer1, UnsignedByteBuffer buffer2, int offset1, int offset2) {
        float value = buffer1.get(offset1);
        buffer2.putRaw(offset2, value >= this.level ? this.byteOn : this.byteOff);
    }
}

