/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.imagej.convert;

import ij.ImageStack;
import ij.process.ImageProcessor;
import java.util.function.IntFunction;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import org.anchoranalysis.core.functional.CheckedStream;
import org.anchoranalysis.core.functional.checked.CheckedIntFunction;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.datatype.UnsignedByteVoxelType;
import org.anchoranalysis.image.voxel.datatype.VoxelDataType;
import org.anchoranalysis.io.imagej.convert.ConvertToImageProcessor;
import org.anchoranalysis.io.imagej.convert.ImageJConversionException;
import org.anchoranalysis.io.imagej.convert.RGBVoxels;
import org.anchoranalysis.spatial.box.Extent;

class ImageStackFactory {
    public static ImageStack createFromStack(Stack stack, boolean makeRGB) throws ImageJConversionException {
        if (makeRGB) {
            return ImageStackFactory.createRGB(new RGBStack(stack));
        }
        return ImageStackFactory.createInterleaved(stack);
    }

    public static ImageStack createRGB(RGBStack stack) throws ImageJConversionException {
        if (!stack.allChannelsHaveType((VoxelDataType)UnsignedByteVoxelType.INSTANCE)) {
            throw new ImageJConversionException("Only unsigned 8-bit channels are supported for an ImageJ RGB image");
        }
        Extent extent = stack.getChannel(0).extent();
        int channelIndex = 0;
        RGBVoxels voxels = new RGBVoxels(ImageStackFactory.extractChannel(stack, channelIndex++), ImageStackFactory.extractChannel(stack, channelIndex++), ImageStackFactory.extractChannel(stack, channelIndex));
        return ImageStackFactory.createFromProcessorsStream(extent, (CheckedIntFunction<Stream<ImageProcessor>, ImageJConversionException>)((CheckedIntFunction)z -> Stream.of(voxels.createColorProcessor(extent, z))));
    }

    public static ImageStack createInterleaved(Stack stack) throws ImageJConversionException {
        return ImageStackFactory.createFromVoxelsStream(stack.extent(), z -> IntStream.range(0, stack.getNumberChannels()).mapToObj(index -> stack.getChannel(index).voxels()));
    }

    public static ImageStack createSingleChannel(VoxelsUntyped voxels) throws ImageJConversionException {
        return ImageStackFactory.createFromVoxelsStream(voxels.extent(), z -> Stream.of(voxels));
    }

    private static ImageStack createFromVoxelsStream(Extent extent, IntFunction<Stream<VoxelsUntyped>> createSlice) throws ImageJConversionException {
        return ImageStackFactory.createFromProcessorsStream(extent, (CheckedIntFunction<Stream<ImageProcessor>, ImageJConversionException>)((CheckedIntFunction)z -> CheckedStream.map((Stream)((Stream)createSlice.apply(z)), ImageJConversionException.class, voxels -> ConvertToImageProcessor.from(voxels, z))));
    }

    private static ImageStack createFromProcessorsStream(Extent extent, CheckedIntFunction<Stream<ImageProcessor>, ImageJConversionException> createSlice) throws ImageJConversionException {
        ImageStack stack = new ImageStack(extent.x(), extent.y());
        extent.iterateOverZ(z -> ImageStackFactory.addSlices(stack, z, (Stream)createSlice.apply(z)));
        return stack;
    }

    private static void addSlices(ImageStack stack, int z, Stream<ImageProcessor> slices) throws ImageJConversionException {
        try {
            slices.forEach(slice -> stack.addSlice(String.valueOf(z), slice));
        }
        catch (Exception e) {
            throw new ImageJConversionException(e);
        }
    }

    private static Voxels<UnsignedByteBuffer> extractChannel(RGBStack stack, int channelIndex) {
        return stack.getChannel(channelIndex).voxels().asByte();
    }

    private ImageStackFactory() {
    }
}

