/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.imagej.convert;

import com.google.common.base.Preconditions;
import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import lombok.Generated;

class CompositeFactory {
    private static final String IMAGEJ_IMAGE_NAME = "imagename";
    private final ImageStack stack;
    private final int numberSlices;
    private final int numberFrames;

    public ImagePlus create(int numberChannels, boolean makeComposite) {
        if (makeComposite) {
            return this.createComposite(numberChannels);
        }
        return this.createNonComposite(1);
    }

    private ImagePlus createComposite(int numberChannels) {
        ImagePlus nonComposite = this.createNonComposite(numberChannels);
        Preconditions.checkArgument((nonComposite.getNSlices() == this.numberSlices ? 1 : 0) != 0);
        CompositeImage composite = new CompositeImage(nonComposite, 2);
        composite.setDimensions(numberChannels, this.numberSlices, this.numberFrames);
        return composite;
    }

    private ImagePlus createNonComposite(int numberChannelsForComposite) {
        ImagePlus imp = new ImagePlus();
        imp.setStack(this.stack, numberChannelsForComposite, this.numberSlices, this.numberFrames);
        imp.setTitle(IMAGEJ_IMAGE_NAME);
        return imp;
    }

    @Generated
    public CompositeFactory(ImageStack stack, int numberSlices, int numberFrames) {
        this.stack = stack;
        this.numberSlices = numberSlices;
        this.numberFrames = numberFrames;
    }
}

