/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.imagej.convert;

import com.google.common.base.Preconditions;
import ij.CompositeImage;
import ij.ImagePlus;
import ij.ImageStack;
import ij.measure.Calibration;
import ij.process.ImageProcessor;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.friendly.AnchorFriendlyRuntimeException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.buffer.slice.SliceBufferIndex;
import org.anchoranalysis.io.imagej.convert.CompositeFactory;
import org.anchoranalysis.io.imagej.convert.ConvertToImageProcessor;
import org.anchoranalysis.io.imagej.convert.ImageJConversionException;
import org.anchoranalysis.io.imagej.convert.ImageStackFactory;

public class ConvertToImagePlus {
    private static final String IMAGEJ_UNIT_MICRON = "micron";
    private static final int MICRONS_TO_METERS = 1000000;

    public static ImagePlus from(VoxelsUntyped voxels) throws ImageJConversionException {
        Dimensions dimensions = new Dimensions(voxels.any().extent(), Optional.empty());
        ImageStack stack = ImageStackFactory.createSingleChannel(voxels);
        return ConvertToImagePlus.createImagePlus(stack, dimensions, 1, 1, false);
    }

    public static ImagePlus from(Channel channel) throws ImageJConversionException {
        return ConvertToImagePlus.from(channel.voxels());
    }

    public static ImagePlus from(Stack stack, boolean makeRGB) throws ImageJConversionException {
        ImageStack stackNew = ImageStackFactory.createFromStack(stack, makeRGB);
        boolean makeComposite = !makeRGB && stack.getNumberChannels() != 1;
        ImagePlus imagePlus = ConvertToImagePlus.createImagePlus(stackNew, stack.dimensions(), stack.getNumberChannels(), 1, makeComposite);
        ConvertToImagePlus.maybeCorrectComposite(stack, imagePlus);
        Preconditions.checkArgument((imagePlus.getNSlices() == stack.extent().z() ? 1 : 0) != 0);
        return imagePlus;
    }

    public static ImagePlus fromSlice(Voxels<UnsignedByteBuffer> voxels, int sliceIndex, String name) {
        ImageProcessor processor = ConvertToImageProcessor.fromByte((SliceBufferIndex<UnsignedByteBuffer>)voxels.slices(), sliceIndex);
        return new ImagePlus(name, processor);
    }

    private static ImagePlus createImagePlus(ImageStack stack, Dimensions dimensions, int numberChannels, int numberFrames, boolean makeComposite) {
        CompositeFactory composite = new CompositeFactory(stack, dimensions.z(), numberFrames);
        ImagePlus image = composite.create(numberChannels, makeComposite);
        dimensions.resolution().ifPresent(resolution -> ConvertToImagePlus.configureCalibration(image.getCalibration(), resolution));
        if (numberChannels == 1) {
            image.setDisplayMode(3);
        }
        ConvertToImagePlus.checkNumberSlices(image, dimensions);
        return image;
    }

    private static void configureCalibration(Calibration calibration, Resolution resolution) {
        calibration.setXUnit(IMAGEJ_UNIT_MICRON);
        calibration.setYUnit(IMAGEJ_UNIT_MICRON);
        calibration.setZUnit(IMAGEJ_UNIT_MICRON);
        calibration.pixelWidth = resolution.x() * 1000000.0;
        calibration.pixelHeight = resolution.y() * 1000000.0;
        calibration.pixelDepth = resolution.z() * 1000000.0;
    }

    private static void checkNumberSlices(ImagePlus image, Dimensions dimensions) {
        if (image.getNSlices() != dimensions.z()) {
            throw new AnchorFriendlyRuntimeException(String.format("Number of slices in imagePlus (%d) is not equal to z-slices in scene (%d)", image.getNSlices(), dimensions.z()));
        }
    }

    private static void maybeCorrectComposite(Stack stack, ImagePlus image) {
        if (stack.getNumberChannels() == 1 && image instanceof CompositeImage) {
            CompositeImage iageCast = (CompositeImage)image;
            iageCast.setMode(3);
        }
    }

    @Generated
    private ConvertToImagePlus() {
    }
}

