/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input;

import java.nio.file.Path;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Optional;
import java.util.function.Function;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.functional.checked.CheckedFunction;
import org.anchoranalysis.io.input.FindNonInputFiles;
import org.anchoranalysis.io.input.InputFromManager;
import org.anchoranalysis.io.input.file.NamedFile;

public final class InputsWithDirectory<T extends InputFromManager> {
    private final List<T> inputs;
    private final Optional<Path> directory;

    public InputsWithDirectory(List<T> inputs) {
        this(inputs, Optional.empty());
    }

    public <S extends InputFromManager> InputsWithDirectory<S> map(Function<T, S> mapFunction) {
        return new InputsWithDirectory<T>(FunctionalList.mapToList(this.inputs, mapFunction), this.directory);
    }

    public <S extends InputFromManager, E extends Exception> InputsWithDirectory<S> map(CheckedFunction<T, S, E> mapFunction, Class<? extends E> throwableClass) throws E {
        return new InputsWithDirectory<T>(FunctionalList.mapToList(this.inputs, throwableClass, mapFunction), this.directory);
    }

    public <S extends InputFromManager> InputsWithDirectory<S> withInputs(List<S> inputsToAssign) {
        return new InputsWithDirectory<S>(inputsToAssign, this.directory);
    }

    public Collection<NamedFile> findAllNonInputFiles() throws OperationFailedException {
        if (this.directory.isPresent()) {
            return FindNonInputFiles.from(this.directory.get(), this.inputs);
        }
        throw new OperationFailedException("A directory is not defined, so this operation is not possible.");
    }

    public boolean isEmpty() {
        return this.inputs.isEmpty();
    }

    public Iterator<T> iterator() {
        return this.inputs.iterator();
    }

    public ListIterator<T> listIterator() {
        return this.inputs.listIterator();
    }

    public List<T> inputs() {
        return this.inputs;
    }

    public Optional<Path> directory() {
        return this.directory;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof InputsWithDirectory)) {
            return false;
        }
        InputsWithDirectory other = (InputsWithDirectory)o;
        List<T> this$inputs = this.inputs();
        List<T> other$inputs = other.inputs();
        if (this$inputs == null ? other$inputs != null : !((Object)this$inputs).equals(other$inputs)) {
            return false;
        }
        Optional<Path> this$directory = this.directory();
        Optional<Path> other$directory = other.directory();
        return !(this$directory == null ? other$directory != null : !((Object)this$directory).equals(other$directory));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<T> $inputs = this.inputs();
        result = result * 59 + ($inputs == null ? 43 : ((Object)$inputs).hashCode());
        Optional<Path> $directory = this.directory();
        result = result * 59 + ($directory == null ? 43 : ((Object)$directory).hashCode());
        return result;
    }

    public String toString() {
        return "InputsWithDirectory(inputs=" + this.inputs() + ", directory=" + this.directory() + ")";
    }

    public InputsWithDirectory(List<T> inputs, Optional<Path> directory) {
        this.inputs = inputs;
        this.directory = directory;
    }
}

