/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.io.input.bean;

import java.util.Optional;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.io.input.InputContextParameters;
import org.anchoranalysis.io.input.bean.DebugModeParameters;

public class InputManagerParameters {
    private final InputContextParameters inputContext;
    private final OperationContext operationContext;

    public InputManagerParameters(Logger logger) {
        this(new OperationContext(logger));
    }

    public InputManagerParameters(OperationContext operationContext) {
        this(new InputContextParameters(), operationContext);
    }

    public boolean isDebugModeActivated() {
        return this.inputContext.getDebugModeParameters().isPresent();
    }

    public Optional<DebugModeParameters> getDebugModeParameters() {
        return this.inputContext.getDebugModeParameters();
    }

    public ExecutionTimeRecorder getExecutionTimeRecorder() {
        return this.operationContext.getExecutionTimeRecorder();
    }

    public Logger getLogger() {
        return this.operationContext.getLogger();
    }

    public InputManagerParameters(InputContextParameters inputContext, OperationContext operationContext) {
        this.inputContext = inputContext;
        this.operationContext = operationContext;
    }

    public InputContextParameters getInputContext() {
        return this.inputContext;
    }

    public OperationContext getOperationContext() {
        return this.operationContext;
    }
}

